/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NonRestorableView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinboardPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(PinboardPerspective.class);

    public PinboardPerspective() {
        super("pinboard", LocalizationHelper.getI18n(PinboardPerspective.class).tr("Pinboard"), ResourceManager.getImage((String)"icons/perspective-pinboard.png"));
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = false;
        configuration.hasSupplementalArea = false;
        configuration.multiViewMainArea = true;
        configuration.enableViewPinning = false;
        configuration.allViewsAreCloseable = true;
        configuration.useGlobalViewId = true;
        configuration.ignoreViewContext = true;
        configuration.enableViewHide = false;
        configuration.keyboardShortcut = new KeyStroke(0x1000015);
    }

    public void saveState(Memento memento) {
        ArrayList<String> views = new ArrayList<String>();
        for (View v : this.getAllMainViews()) {
            String id = v.getGlobalId();
            views.add(id);
            Memento viewConfig = new Memento();
            v.saveState(viewConfig);
            memento.set(id + ".state", viewConfig);
        }
        memento.set("PinboardPerspective.Views", views);
    }

    public void restoreState(Memento memento) {
        List views = memento.getAsStringList("PinboardPerspective.Views");
        for (String id : views) {
            Memento viewConfig = memento.getAsMemento(id + ".state");
            View v = null;
            try {
                Class<?> viewClass = Class.forName(viewConfig.getAsString("class"));
                Constructor<?> c = viewClass.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                v = (View)c.newInstance(new Object[0]);
                if (v == null) continue;
                v.restoreState(viewConfig);
                Registry.getMainWindow().pinView(v, PinLocation.PINBOARD);
            }
            catch (Exception e) {
                Registry.getMainWindow().pinView((View)new NonRestorableView(e, v != null ? v.getFullName() : id), PinLocation.PINBOARD);
                logger.error("Cannot instantiate saved view", (Throwable)e);
            }
        }
    }
}

