/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.AlarmCategory;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.editors.AlarmCategoryEditor;
import org.netxms.nxmc.modules.alarms.propertypages.AccessControl;
import org.netxms.nxmc.modules.alarms.propertypages.General;
import org.netxms.nxmc.modules.alarms.widgets.AlarmCategoryList;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmCategoryLabelProvider;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmCategoryListComparator;
import org.netxms.nxmc.modules.alarms.widgets.helpers.AlarmCategoryListFilter;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AlarmCategoryList
extends Composite
implements SessionListener {
    private I18n i18n = LocalizationHelper.getI18n(AlarmCategoryList.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private AlarmCategoryListFilter filter;
    private Action actionAddCategory;
    private Action actionEditCategory;
    private Action actionDeleteCategory;
    private NXCSession session = Registry.getSession();
    private IStructuredSelection selection;
    private SortableTableViewer viewer;
    private View viewPart;
    private HashMap<Long, AlarmCategory> alarmCategories;

    public AlarmCategoryList(View viewPart, Composite parent, int style, String configPrefix, boolean showFilter) {
        this(parent, style, configPrefix, showFilter);
        this.viewPart = viewPart;
    }

    public AlarmCategoryList(Composite parent, int style, String configPrefix, boolean showCloseButton) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Description")};
        int[] widths = new int[]{50, 200, 200};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 1, 128, 68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AlarmCategoryLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new AlarmCategoryListComparator());
        this.filter = new AlarmCategoryListFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.addListener(11, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refreshView();
        this.session.addListener((SessionListener)this);
    }

    private void onSelectionChange() {
        this.selection = this.getSelection();
        this.actionEditCategory.setEnabled(this.selection.size() == 1);
        this.actionDeleteCategory.setEnabled(this.selection.size() > 0);
    }

    public void refreshView() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionAddCategory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddCategory.setText(this.i18n.tr("Add category"));
        this.actionAddCategory.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEditCategory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditCategory.setText(this.i18n.tr("Edit category"));
        this.actionEditCategory.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditCategory.setEnabled(false);
        this.actionDeleteCategory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteCategory.setText(this.i18n.tr("Delete category"));
        this.actionDeleteCategory.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionDeleteCategory.setEnabled(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionEditCategory);
        manager.add((IAction)this.actionDeleteCategory);
        manager.add((IAction)this.actionAddCategory);
    }

    public void createCategory() {
        this.showDCIPropertyPages(new AlarmCategory());
    }

    public void editCategory() {
        if (this.selection.isEmpty()) {
            return;
        }
        this.showDCIPropertyPages((AlarmCategory)this.selection.getFirstElement());
    }

    protected boolean showDCIPropertyPages(AlarmCategory alarmCategory) {
        AlarmCategoryEditor editor = new AlarmCategoryEditor(alarmCategory);
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(editor)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("accessControl", (IPreferencePage)new AccessControl(editor)));
        9 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    private void deleteCategory() {
        String message;
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String string = message = selection.size() == 1 ? this.i18n.tr("Do you really wish to delete the selected category?") : this.i18n.tr("Do you really wish to delete the selected categories?");
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Confirm category deletion"), (String)message)) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public Action getAddCategoryAction() {
        return this.actionAddCategory;
    }

    public Action getEditCategoryAction() {
        return this.actionEditCategory;
    }

    public Action getDeleteCategoryAction() {
        return this.actionDeleteCategory;
    }

    public IStructuredSelection getSelection() {
        return this.viewer.getStructuredSelection();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1030: {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1031: {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    public AbstractViewerFilter getFilter() {
        return this.filter;
    }
}

