/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmHandle;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.ZoneMember;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class AlarmListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private final I18n i18n = LocalizationHelper.getI18n(AlarmListLabelProvider.class);
    private static final String[] stateText = new String[]{LocalizationHelper.getI18n(AlarmListLabelProvider.class).tr("Outstanding"), LocalizationHelper.getI18n(AlarmListLabelProvider.class).tr("Acknowledged"), LocalizationHelper.getI18n(AlarmListLabelProvider.class).tr("Resolved"), LocalizationHelper.getI18n(AlarmListLabelProvider.class).tr("Terminated")};
    private NXCSession session;
    private Image[] stateImages = new Image[5];
    private boolean blinkState = true;
    private boolean showColor = true;
    private TreeViewer viewer;
    private BaseObjectLabelProvider objectLabelProvider;

    public AlarmListLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
        this.session = Registry.getSession();
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.stateImages[0] = ResourceManager.getImage((String)"icons/alarms/outstanding.png");
        this.stateImages[1] = ResourceManager.getImage((String)"icons/alarms/acknowledged.png");
        this.stateImages[2] = ResourceManager.getImage((String)"icons/alarms/resolved.png");
        this.stateImages[3] = ResourceManager.getImage((String)"icons/alarms/terminated.png");
        this.stateImages[4] = ResourceManager.getImage((String)"icons/alarms/acknowledged_sticky.png");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Alarm alarm = ((AlarmHandle)element).alarm;
        switch ((Integer)this.viewer.getTree().getColumn(columnIndex).getData("ID")) {
            case 0: {
                return StatusDisplayInfo.getStatusImage((Severity)alarm.getCurrentSeverity());
            }
            case 1: {
                if (alarm.getState() == 0) {
                    return this.blinkState ? this.stateImages[0] : SharedIcons.IMG_EMPTY;
                }
                if (alarm.getState() == 1 && alarm.isSticky()) {
                    return this.stateImages[4];
                }
                return this.stateImages[alarm.getState()];
            }
            case 2: {
                AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
                return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
            }
            case 6: {
                return alarm.getCommentsCount() > 0 ? SharedIcons.IMG_COMMENTS : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Alarm alarm = ((AlarmHandle)element).alarm;
        switch ((Integer)this.viewer.getTree().getColumn(columnIndex).getData("ID")) {
            case 0: {
                return StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity());
            }
            case 1: {
                int time = alarm.getAckTime();
                String timeString = time > 0 ? " (" + DateFormatFactory.getDateTimeFormat().format(System.currentTimeMillis() + (long)(time * 1000)) + ")" : "";
                return stateText[alarm.getState()] + timeString;
            }
            case 2: {
                AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
                return object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]";
            }
            case 3: {
                if (this.session.isZoningEnabled()) {
                    ZoneMember zm = (ZoneMember)this.session.findObjectById(alarm.getSourceObjectId(), ZoneMember.class);
                    return zm != null ? zm.getZoneName() : "";
                }
                return "";
            }
            case 4: {
                return alarm.getMessage();
            }
            case 5: {
                return Integer.toString(alarm.getRepeatCount());
            }
            case 6: {
                return alarm.getCommentsCount() > 0 ? Integer.toString(alarm.getCommentsCount()) : null;
            }
            case 8: {
                if (alarm.getState() == 0) {
                    return null;
                }
                int userId = alarm.getState() == 1 ? alarm.getAcknowledgedByUser() : alarm.getResolvedByUser();
                AbstractUserObject user = this.session.findUserDBObjectById(userId, (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + Long.toString(userId) + "]";
            }
            case 9: {
                return DateFormatFactory.getDateTimeFormat().format(alarm.getCreationTime());
            }
            case 10: {
                return DateFormatFactory.getDateTimeFormat().format(alarm.getLastChangeTime());
            }
            case 7: {
                switch (alarm.getHelpdeskState()) {
                    case 1: {
                        return alarm.getHelpdeskReference();
                    }
                    case 2: {
                        return alarm.getHelpdeskReference() + this.i18n.tr(" (closed)");
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void dispose() {
        for (int i = 0; i < this.stateImages.length; ++i) {
            this.stateImages[i].dispose();
        }
        this.objectLabelProvider.dispose();
        super.dispose();
    }

    public void toggleBlinkState() {
        this.blinkState = !this.blinkState;
    }

    public void stopBlinking() {
        this.blinkState = true;
    }

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[((AlarmHandle)element).alarm.getCurrentSeverity().getValue()] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((Severity)((AlarmHandle)element).alarm.getCurrentSeverity()) : null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }
}

