/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.HashMap;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.propertypages.Graph;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListComparator;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class Graph
extends PreferencePage {
    private final I18n i18n = LocalizationHelper.getI18n(Graph.class);
    private GraphDefinition settings;
    private LabeledText name;
    private SortableTableViewer userList;
    private HashMap<Integer, Button> accessChecks = new HashMap(2);
    private HashMap<Integer, AccessListElement> acl;
    private boolean saveToDatabase;

    public Graph(GraphDefinition settings, boolean saveToDatabase) {
        super(settings.isTemplate() ? "Template Graph" : "Predefined Graph");
        this.settings = settings;
        this.saveToDatabase = saveToDatabase;
    }

    protected Control createContents(Composite parent) {
        this.acl = new HashMap(this.settings.getAccessList().size());
        for (AccessListElement e : this.settings.getAccessList()) {
            this.acl.put(e.getUserId(), new AccessListElement(e));
        }
        NXCSession session = Registry.getSession();
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0, 2048);
        this.name.setLabel(this.i18n.tr("Name"));
        this.name.setText(this.settings.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        Group users = new Group(dialogArea, 0);
        users.setText(this.i18n.tr("Users and Groups"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        users.setLayoutData((Object)gd);
        layout = new GridLayout();
        users.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Login name"), this.i18n.tr("Rights")};
        int[] columnWidths = new int[]{150, 100};
        this.userList = new SortableTableViewer((Composite)users, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.userList.setComparator((ViewerComparator)new AccessListComparator());
        this.userList.setInput((Object)this.acl.values().toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)users, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group rights = new Group(dialogArea, 0);
        rights.setText(this.i18n.tr("Access Rights"));
        rights.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        rights.setLayoutData((Object)gd);
        this.createAccessCheck((Composite)rights, this.i18n.tr("&Read"), Integer.valueOf(1));
        this.createAccessCheck((Composite)rights, this.i18n.tr("&Modify"), Integer.valueOf(2));
        this.userList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void createAccessCheck(Composite parent, String name, Integer bitMask) {
        Button check = new Button(parent, 32);
        check.setText(name);
        check.setEnabled(false);
        check.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.accessChecks.put(bitMask, check);
    }

    private void enableAllChecks(boolean enabled) {
        for (Button b : this.accessChecks.values()) {
            b.setEnabled(enabled);
        }
    }

    protected void applyChanges(boolean isApply) {
        if (!this.isControlCreated()) {
            return;
        }
        this.settings.setName(this.name.getText());
        this.settings.getAccessList().clear();
        this.settings.getAccessList().addAll(this.acl.values());
        if (isApply && this.saveToDatabase) {
            this.setValid(false);
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.acl.clear();
        this.userList.setInput((Object)this.acl.values().toArray());
    }
}

