/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.dialogs;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.DiffMatchPatch;
import org.netxms.client.log.LogRecordDetails;
import org.netxms.nxmc.base.widgets.DiffViewer;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;

public class AuditLogRecordDetailsDialog
extends Dialog {
    private LogRecordDetails data;
    private CTabFolder tabFolder;

    public AuditLogRecordDetailsDialog(Shell parentShell, LogRecordDetails data) {
        super(parentShell);
        this.data = data;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Audit Log Record Details");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(dialogArea, 2048);
        this.tabFolder.setTabHeight(24);
        WidgetHelper.disableTabFolderSelectionBar((CTabFolder)this.tabFolder);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 800;
        gd.heightHint = 500;
        this.tabFolder.setLayoutData((Object)gd);
        String oldValue = this.data.getValue("old_value");
        String newValue = this.data.getValue("new_value");
        DiffMatchPatch diffEngine = new DiffMatchPatch();
        LinkedList diffs = diffEngine.diff_main(oldValue, newValue);
        diffEngine.diff_cleanupSemantic(diffs);
        diffEngine.diff_prettyHtml((List)diffs);
        this.createTextValueTab("Old value", "icons/old_value.png", oldValue);
        this.createTextValueTab("New value", "icons/new_value.png", newValue);
        this.createDiffTab(diffs);
        this.tabFolder.setSelection(2);
        return dialogArea;
    }

    private void createTextValueTab(String name, String imageName, String text) {
        CTabItem tab = this.createTab(name, imageName);
        StyledText textControl = new StyledText((Composite)this.tabFolder, 778);
        textControl.setFont(JFaceResources.getTextFont());
        textControl.setText(text);
        tab.setControl((Control)textControl);
    }

    private void createDiffTab(LinkedList<DiffMatchPatch.Diff> diffs) {
        CTabItem tab = this.createTab("Diff", "icons/diff.png");
        DiffViewer viewer = new DiffViewer((Composite)this.tabFolder, 0);
        viewer.setContent(diffs);
        tab.setControl((Control)viewer);
    }

    private CTabItem createTab(String name, String imageName) {
        CTabItem tab = new CTabItem(this.tabFolder, 0);
        tab.setText(name);
        Image image = ResourceManager.getImage((String)imageName);
        tab.setImage(image);
        tab.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        return tab;
    }
}

