/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.snmp.MibCompilationLogEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileComparator;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.nxmc.modules.snmp.views.MibFileManager;
import org.netxms.nxmc.modules.snmp.views.helpers.MibCompilationErrorLogProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MibFileManager
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(MibFileManager.class);
    private static final String TABLE_CONFIG_PREFIX = "MibFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int ERROR_COLUMN_SEVERITY = 0;
    public static final int ERROR_COLUMN_LOCATION = 1;
    public static final int ERROR_COLUMN_MESSAGE = 2;
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private String filterString = "";
    private Image errorLogIcon;
    private Image outputIcon;
    private TextConsole outputViewer;
    private SortableTableViewer errorLogViewer;
    private Action actionUpload;
    private Action actionDelete;
    private Action actionCompile;
    private List<MibCompilationLogEntry> errors = new ArrayList();

    public MibFileManager() {
        super(LocalizationHelper.getI18n(MibFileManager.class).tr("SNMP MIB Files"), ResourceManager.getImageDescriptor((String)"icons/config-views/mib-files.png"), "config.mib-files", true);
    }

    public void createContent(Composite parent) {
        SashForm content = new SashForm(parent, 512);
        Composite listArea = new Composite((Composite)content, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        listArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Size"), this.i18n.tr("Modified")};
        int[] columnWidths = new int[]{300, 150, 300, 300};
        this.viewer = new SortableTableViewer(listArea, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(listArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.errorLogIcon = ResourceManager.getImage((String)"icons/error_log.png");
        this.outputIcon = ResourceManager.getImage((String)"icons/console.png");
        Composite outputArea = new Composite((Composite)content, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        outputArea.setLayout((Layout)layout);
        new Label(outputArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CTabFolder outputTabFolder = new CTabFolder(outputArea, 128);
        outputTabFolder.setTabHeight(26);
        WidgetHelper.disableTabFolderSelectionBar((CTabFolder)outputTabFolder);
        outputTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(outputTabFolder, 0);
        tabItem.setText("Output");
        tabItem.setImage(this.outputIcon);
        this.outputViewer = new TextConsole((Composite)outputTabFolder, 0);
        tabItem.setControl((Control)this.outputViewer);
        tabItem = new CTabItem(outputTabFolder, 0);
        tabItem.setText("Error Log");
        tabItem.setImage(this.errorLogIcon);
        String[] names = new String[]{this.i18n.tr("Severity"), this.i18n.tr("Location"), this.i18n.tr("Message")};
        int[] widths = new int[]{100, 300, 600};
        this.errorLogViewer = new SortableTableViewer((Composite)outputTabFolder, names, widths, 0, 128, 65538);
        this.errorLogViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.errorLogViewer.setLabelProvider((IBaseLabelProvider)new MibCompilationErrorLogProvider());
        this.errorLogViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.errorLogViewer.getLabelProvider()));
        tabItem.setControl(this.errorLogViewer.getControl());
        this.errorLogViewer.setInput((Object)this.errors);
        outputTabFolder.setSelection(0);
        content.setSashWidth(3);
        content.setWeights(new int[]{70, 30});
        this.createActions();
        this.createContextMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    private void createActions() {
        this.actionUpload = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+U", (IAction)this.actionUpload);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionCompile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F7", (IAction)this.actionCompile);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionUpload);
        manager.add((IAction)this.actionCompile);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUpload);
        manager.add((IAction)this.actionCompile);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (!this.viewer.getStructuredSelection().isEmpty()) {
            mgr.add((IAction)this.actionDelete);
            mgr.add((IContributionItem)new Separator());
        }
        mgr.add((IAction)this.actionUpload);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void uploadFile() {
        FileDialog fd = new FileDialog(this.getWindow().getShell(), 4098);
        fd.setText("Select Files");
        String selection = fd.open();
        if (selection == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fname : fd.getFileNames()) {
            files.add(Paths.get(fname, new String[0]).isAbsolute() ? new File(fname) : new File(new File(selection).getParentFile(), fname));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteFile() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete File"), (String)this.i18n.tr("Are you sure you want to delete selected files?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void compileMibFiles() {
        this.actionCompile.setEnabled(false);
        this.outputViewer.setText("");
        this.errors.clear();
        this.errorLogViewer.refresh();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void processCompilationLogEntry(MibCompilationLogEntry entry) {
        this.getDisplay().asyncExec(() -> {
            switch (13.$SwitchMap$org$netxms$client$snmp$MibCompilationLogEntry$MessageType[entry.getType().ordinal()]) {
                case 1: 
                case 2: {
                    this.outputViewer.append("\u001b[34;1m" + entry.getText() + "\u001b[0m");
                    break;
                }
                case 3: {
                    this.outputViewer.append("   \u001b[37m" + entry.getFileName() + "\u001b[0m");
                    break;
                }
                case 4: {
                    this.outputViewer.append("   \u001b[33;1mWarning:\u001b[36m " + entry.getFileName() + "\u001b[0m: " + entry.getText());
                    break;
                }
                case 5: {
                    this.outputViewer.append("   \u001b[31;1mError:\u001b[36m " + entry.getFileName() + "\u001b[0m: " + entry.getText());
                }
            }
            this.outputViewer.append("\n");
            if (entry.isErrorInformation()) {
                this.errors.add(entry);
                this.errorLogViewer.refresh();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1025 && n.getSubCode() == 1L) {
            this.getDisplay().asyncExec(() -> this.refresh());
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        this.errorLogIcon.dispose();
        this.outputIcon.dispose();
        super.dispose();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

