/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.constants.UserAuthenticationMethod;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.actions.GenerateObjectAccessReportAction;
import org.netxms.nxmc.modules.users.dialogs.ChangePasswordDialog;
import org.netxms.nxmc.modules.users.dialogs.CreateUserOrGroupDialog;
import org.netxms.nxmc.modules.users.dialogs.IssueTokenDialog;
import org.netxms.nxmc.modules.users.views.UserManagementView;
import org.netxms.nxmc.modules.users.views.helpers.DecoratingUserLabelProvider;
import org.netxms.nxmc.modules.users.views.helpers.UserComparator;
import org.netxms.nxmc.modules.users.views.helpers.UserFilter;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class UserManagementView
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(UserManagementView.class);
    private static final String ID = "configuration.user-manager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_FULLNAME = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    public static final int COLUMN_SOURCE = 4;
    public static final int COLUMN_AUTH_METHOD = 5;
    public static final int COLUMN_GUID = 6;
    public static final int COLUMN_LDAP_DN = 7;
    public static final int COLUMN_LAST_LOGIN = 8;
    public static final int COLUMN_CREATED = 9;
    private SortableTableViewer viewer;
    private NXCSession session = Registry.getSession();
    private SessionListener sessionListener;
    private boolean editNewUser = false;
    private Action actionAddUser;
    private Action actionAddGroup;
    private Action actionEditUser;
    private Action actionDeleteUser;
    private Action actionChangePassword;
    private Action actionIssueToken;
    private Action actionEnable;
    private Action actionDisable;
    private Action actionDetachUserFromLDAP;
    private Action actionGenerateAccessReport;
    private UserFilter filter;

    public UserManagementView() {
        super(LocalizationHelper.getI18n(UserManagementView.class).tr("Users and Groups"), ResourceManager.getImageDescriptor((String)"icons/config-views/user_manager.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Full name"), this.i18n.tr("Description"), this.i18n.tr("Source"), this.i18n.tr("Authentication"), this.i18n.tr("GUID"), this.i18n.tr("LDAP DN"), this.i18n.tr("Last login"), this.i18n.tr("Created")};
        int[] widths = new int[]{100, 80, 180, 250, 80, 170, 250, 400, 250, 250};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DecoratingUserLabelProvider labelProvider = new DecoratingUserLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new UserComparator());
        this.filter = new UserFilter(labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.viewer.setInput((Object)this.session.getUserDatabaseObjects());
        this.getUsersAndRefresh();
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionAddUser = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddGroup = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditUser = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditUser.setEnabled(false);
        this.actionDeleteUser = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteUser.setEnabled(false);
        this.actionChangePassword = new /* Unavailable Anonymous Inner Class!! */;
        this.actionChangePassword.setEnabled(false);
        this.actionIssueToken = new /* Unavailable Anonymous Inner Class!! */;
        this.actionIssueToken.setEnabled(false);
        this.actionEnable = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDetachUserFromLDAP = new /* Unavailable Anonymous Inner Class!! */;
        this.actionGenerateAccessReport = new GenerateObjectAccessReportAction(this.i18n.tr("Generate object access report..."), (View)this);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionGenerateAccessReport);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionGenerateAccessReport);
        super.fillLocalMenu(manager);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        mgr.add((IAction)this.actionAddUser);
        mgr.add((IAction)this.actionAddGroup);
        mgr.add((IContributionItem)new Separator());
        boolean containDisabled = false;
        boolean containEnabled = false;
        boolean containLDAP = false;
        for (Object object : selection.toList()) {
            if (((AbstractUserObject)object).isDisabled()) {
                containDisabled = true;
            }
            if (!((AbstractUserObject)object).isDisabled()) {
                containEnabled = true;
            }
            if ((((AbstractUserObject)object).getFlags() & 0x80) == 0) continue;
            containLDAP = true;
        }
        if (containDisabled) {
            mgr.add((IAction)this.actionEnable);
        }
        if (containEnabled) {
            mgr.add((IAction)this.actionDisable);
        }
        if (containLDAP) {
            mgr.add((IAction)this.actionDetachUserFromLDAP);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof User) {
            UserAuthenticationMethod method = ((User)selection.getFirstElement()).getAuthMethod();
            if (method == UserAuthenticationMethod.LOCAL || method == UserAuthenticationMethod.CERTIFICATE_OR_LOCAL) {
                mgr.add((IAction)this.actionChangePassword);
            }
            mgr.add((IAction)this.actionIssueToken);
        }
        mgr.add((IAction)this.actionDeleteUser);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEditUser);
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        super.dispose();
    }

    private void addUser() {
        CreateUserOrGroupDialog dlg = new CreateUserOrGroupDialog(this.getWindow().getShell(), true);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void addGroup() {
        CreateUserOrGroupDialog dlg = new CreateUserOrGroupDialog(this.getWindow().getShell(), false);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void deleteUser() {
        String message;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        String string = message = selection.size() == 1 ? this.i18n.tr("Do you really want to delete selected user?") : this.i18n.tr("Do you really want to delete selected users?");
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm user deletion"), (String)message)) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void enableUser() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<AbstractUserObject> objects = new ArrayList<AbstractUserObject>();
        for (Object o : selection.toList()) {
            objects.add((AbstractUserObject)o);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void disableUser() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<AbstractUserObject> objects = new ArrayList<AbstractUserObject>();
        for (Object o : selection.toList()) {
            objects.add((AbstractUserObject)o);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void changePassword() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof User)) {
            return;
        }
        User user = (User)selection.getFirstElement();
        ChangePasswordDialog dialog = new ChangePasswordDialog(this.getWindow().getShell(), user.getId() == this.session.getUserId());
        if (dialog.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void issueToken() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof User)) {
            return;
        }
        User user = (User)selection.getFirstElement();
        new IssueTokenDialog(this.getWindow().getShell(), user.getId()).open();
    }

    private void detachLDAPUser() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onFilterModify() {
        String text = this.getFilterText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

