/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LinkDataLocation {
    CENTER(0),
    OBJECT1(1),
    OBJECT2(2);

    private static Logger logger;
    private static Map<Integer, LinkDataLocation> lookupTable;
    private int value;

    private LinkDataLocation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LinkDataLocation getByValue(int value) {
        LinkDataLocation layout = lookupTable.get(value);
        if (layout == null) {
            logger.warn("Unknown link data location: " + value);
            return CENTER;
        }
        return layout;
    }

    static {
        logger = LoggerFactory.getLogger(LinkDataLocation.class);
        lookupTable = new HashMap<Integer, LinkDataLocation>();
        for (LinkDataLocation element : LinkDataLocation.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

