/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProxy {
    private static final Logger logger = LoggerFactory.getLogger(TcpProxy.class);
    private NXCSession session;
    private int channelId;
    private ProxyInputStream localInputStream;
    private ProxyOutputStream localOutputStream;
    private int timeThreshold = 100;
    private byte[] sendBuffer = new byte[256];
    private int pendingBytes = 0;
    private Timer sendTimer = new Timer(true);
    private Exception flushException = null;

    protected TcpProxy(NXCSession session, int channelId) throws IOException {
        this.session = session;
        this.channelId = channelId;
        this.localInputStream = new ProxyInputStream();
        this.localOutputStream = new ProxyOutputStream();
        logger.debug("New TCP proxy object created for channel " + channelId);
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        this.session.closeTcpProxy(this.channelId);
        this.localClose();
    }

    protected synchronized void localClose() {
        logger.debug("Local close for TCP proxy channel " + this.channelId);
        this.sendTimer.cancel();
        this.session = null;
        try {
            this.localOutputStream.close();
            this.localInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localInputStream = null;
        this.localOutputStream = null;
    }

    protected synchronized void abort(Throwable cause) {
        logger.debug("Abort for TCP proxy channel " + this.channelId, cause);
        this.localInputStream.setException(cause);
        this.sendTimer.cancel();
        this.session = null;
        try {
            this.localOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.session == null;
    }

    public InputStream getInputStream() {
        return this.localInputStream;
    }

    public OutputStream getOutputStream() {
        return this.localOutputStream;
    }

    protected int getChannelId() {
        return this.channelId;
    }

    public Exception getFlushException() {
        return this.flushException;
    }

    public int getSizeThreshold() {
        return this.sendBuffer.length;
    }

    public int getTimeThreshold() {
        return this.timeThreshold;
    }

    public void setBufferingThresholds(int sizeThreshold, int timeThreshold) {
        this.sendBuffer = new byte[sizeThreshold];
        this.timeThreshold = timeThreshold;
    }

    public synchronized void send(byte[] data) throws IOException, NXCException {
        if (this.flushException != null) {
            throw new IOException(this.flushException);
        }
        if (this.isClosed()) {
            throw new IOException("Proxy channel is closed");
        }
        if (this.pendingBytes + data.length < this.sendBuffer.length) {
            TcpProxy.appendBytes(this.sendBuffer, this.pendingBytes, data, data.length);
            if (this.pendingBytes == 0) {
                this.sendTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        TcpProxy.this.flushSendBuffer();
                    }
                }, this.timeThreshold);
            }
            this.pendingBytes += data.length;
            return;
        }
        NXCPMessage msg = new NXCPMessage(365, this.channelId);
        msg.setBinaryMessage(true);
        if (this.pendingBytes > 0) {
            byte[] buffer;
            if (this.pendingBytes + data.length <= this.sendBuffer.length) {
                TcpProxy.appendBytes(this.sendBuffer, this.pendingBytes, data, data.length);
                buffer = this.sendBuffer;
            } else {
                buffer = new byte[this.pendingBytes + data.length];
                TcpProxy.appendBytes(buffer, 0, this.sendBuffer, this.pendingBytes);
                TcpProxy.appendBytes(buffer, this.pendingBytes, data, data.length);
            }
            msg.setBinaryData(buffer);
            this.pendingBytes = 0;
        } else {
            msg.setBinaryData(data);
        }
        this.session.sendMessage(msg);
    }

    private synchronized void flushSendBuffer() {
        if (this.pendingBytes == 0 || this.isClosed()) {
            return;
        }
        NXCPMessage msg = new NXCPMessage(365, this.channelId);
        msg.setBinaryMessage(true);
        msg.setBinaryData(this.pendingBytes == this.sendBuffer.length ? this.sendBuffer : Arrays.copyOfRange(this.sendBuffer, 0, this.pendingBytes));
        try {
            this.session.sendMessage(msg);
        }
        catch (Exception e) {
            logger.warn("Error flushing TCP proxy buffer", e);
            this.flushException = e;
        }
        this.pendingBytes = 0;
    }

    protected void processRemoteData(byte[] data) {
        this.localInputStream.write(data);
    }

    private static void appendBytes(byte[] target, int offset, byte[] source, int len) {
        int i = 0;
        int j = offset;
        while (i < len) {
            target[j] = source[i];
            ++i;
            ++j;
        }
    }

    private class ProxyInputStream
    extends InputStream {
        private boolean closed = false;
        private byte[] buffer = new byte[65536];
        private int readPos = 0;
        private int writePos = 0;
        private Object monitor = new Object();
        private Throwable exception = null;

        private ProxyInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] data) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.buffer.length - this.writePos < data.length) {
                    if (this.buffer.length - this.writePos + this.readPos >= data.length) {
                        System.arraycopy(this.buffer, this.readPos, this.buffer, 0, this.writePos - this.readPos);
                    } else {
                        byte[] newBuffer = new byte[Math.max(this.buffer.length * 2, data.length + this.buffer.length)];
                        System.arraycopy(this.buffer, this.readPos, newBuffer, 0, this.writePos - this.readPos);
                        this.buffer = newBuffer;
                    }
                    this.writePos -= this.readPos;
                    this.readPos = 0;
                }
                System.arraycopy(data, 0, this.buffer, this.writePos, data.length);
                this.writePos += data.length;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setException(Throwable exception) {
            Object object = this.monitor;
            synchronized (object) {
                this.exception = exception;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                this.closed = true;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                return this.writePos - this.readPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                while (this.readPos == this.writePos) {
                    if (this.exception != null) {
                        throw new IOException(this.exception);
                    }
                    if (this.closed) {
                        return -1;
                    }
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int b = this.buffer[this.readPos++];
                if (this.readPos == this.writePos) {
                    this.readPos = 0;
                    this.writePos = 0;
                }
                return b < 0 ? 129 + b : b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            Object object = this.monitor;
            synchronized (object) {
                while (this.readPos == this.writePos) {
                    if (this.exception != null) {
                        throw new IOException(this.exception);
                    }
                    if (this.closed) {
                        return -1;
                    }
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int bytes = Math.min(len, this.writePos - this.readPos);
                System.arraycopy(this.buffer, this.readPos, b, off, bytes);
                this.readPos += bytes;
                if (this.readPos == this.writePos) {
                    this.readPos = 0;
                    this.writePos = 0;
                }
                return bytes;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    private class ProxyOutputStream
    extends OutputStream {
        private ProxyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] data = new byte[]{(byte)b};
            this.write(data, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (off == 0 && len == b.length) {
                    TcpProxy.this.send(b);
                } else {
                    TcpProxy.this.send(Arrays.copyOfRange(b, off, len));
                }
            }
            catch (NXCException e) {
                throw new IOException(e);
            }
        }
    }
}

