/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.xml.XmlDateConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

@Root(strict=false)
public class TimePeriod {
    @Element(required=false)
    private TimeFrameType timeFrameType;
    @Element(required=false)
    private int timeRange;
    @Element(required=false)
    private TimeUnit timeUnit;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    private Date timeFrom;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    private Date timeTo;

    public TimePeriod(TimeFrameType timeFrameType, int timeRange, TimeUnit timeUnit, Date timeFrom, Date timeTo) {
        this.timeFrameType = timeFrameType;
        this.timeRange = timeRange;
        this.timeUnit = timeUnit;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
    }

    public TimePeriod() {
        this.timeFrameType = TimeFrameType.BACK_FROM_NOW;
        this.timeRange = 1;
        this.timeUnit = TimeUnit.HOUR;
        this.timeTo = new Date();
        this.timeFrom = new Date(this.timeTo.getTime() - 3600000L);
    }

    public boolean isBackFromNow() {
        return this.timeFrameType == TimeFrameType.BACK_FROM_NOW;
    }

    public TimeFrameType getTimeFrameType() {
        return this.timeFrameType;
    }

    public void setTimeFrameType(TimeFrameType timeFrameType) {
        this.timeFrameType = timeFrameType;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.timeRange = timeRange;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    public Date getPeriodStart() {
        if (this.isBackFromNow()) {
            switch (this.timeUnit) {
                case MINUTE: {
                    return new Date(System.currentTimeMillis() - (long)this.timeRange * 60L * 1000L);
                }
                case HOUR: {
                    return new Date(System.currentTimeMillis() - (long)this.timeRange * 60L * 60L * 1000L);
                }
                case DAY: {
                    return new Date(System.currentTimeMillis() - (long)this.timeRange * 24L * 60L * 60L * 1000L);
                }
            }
            return new Date();
        }
        return this.timeFrom;
    }

    public Date getPeriodEnd() {
        return this.isBackFromNow() ? new Date() : this.timeTo;
    }

    public String toString() {
        return "TimePeriod [timeFrameType=" + String.valueOf((Object)this.timeFrameType) + ", timeRange=" + this.timeRange + ", timeUnit=" + String.valueOf((Object)this.timeUnit) + ", timeFrom=" + String.valueOf(this.timeFrom) + ", timeTo=" + String.valueOf(this.timeTo) + "]";
    }
}

