/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.dashboards;

import org.netxms.base.NXCPMessage;

public class DashboardElement {
    public static final int LABEL = 0;
    public static final int LINE_CHART = 1;
    public static final int BAR_CHART = 2;
    public static final int PIE_CHART = 3;
    public static final int TUBE_CHART = 4;
    public static final int STATUS_CHART = 5;
    public static final int STATUS_INDICATOR = 6;
    public static final int DASHBOARD = 7;
    public static final int NETWORK_MAP = 8;
    public static final int CUSTOM = 9;
    public static final int GEO_MAP = 10;
    public static final int ALARM_VIEWER = 11;
    public static final int AVAILABLITY_CHART = 12;
    public static final int DIAL_CHART = 13;
    public static final int WEB_PAGE = 14;
    public static final int TABLE_BAR_CHART = 15;
    public static final int TABLE_PIE_CHART = 16;
    public static final int TABLE_TUBE_CHART = 17;
    public static final int SEPARATOR = 18;
    public static final int TABLE_VALUE = 19;
    public static final int STATUS_MAP = 20;
    public static final int DCI_SUMMARY_TABLE = 21;
    public static final int SYSLOG_MONITOR = 22;
    public static final int SNMP_TRAP_MONITOR = 23;
    public static final int EVENT_MONITOR = 24;
    public static final int SERVICE_COMPONENTS = 25;
    public static final int RACK_DIAGRAM = 26;
    public static final int OBJECT_TOOLS = 27;
    public static final int OBJECT_QUERY = 28;
    public static final int PORT_VIEW = 29;
    public static final int SCRIPTED_BAR_CHART = 30;
    public static final int SCRIPTED_PIE_CHART = 31;
    public static final int FILE_MONITOR = 32;
    public static final int FILL = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int type;
    private String data;
    private String layout;
    private int index;

    public DashboardElement(int type, String data, int index) {
        this.type = type;
        this.data = data;
        this.index = index;
        this.layout = "{\"horizontalSpan\":1,\"verticalSpan\":1,\"horizontalAlignment\":0,\"verticalAlignment\":0}";
    }

    public DashboardElement(NXCPMessage msg, long baseId, int index) {
        this.type = msg.getFieldAsInt32(baseId);
        this.data = msg.getFieldAsString(baseId + 1L);
        this.layout = msg.getFieldAsString(baseId + 2L);
        this.index = index;
    }

    public DashboardElement(DashboardElement src) {
        this.type = src.type;
        this.data = src.data;
        this.layout = src.layout;
        this.index = src.index;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.data);
        msg.setField(baseId + 2L, this.layout);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

