/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import com.google.gson.Gson;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapDCIImage
extends NetworkMapElement {
    private DCIImageConfiguration config;

    protected NetworkMapDCIImage(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String json = msg.getFieldAsString(baseId + 10L);
        try {
            this.config = new Gson().fromJson(json, DCIImageConfiguration.class);
        }
        catch (Exception e) {
            this.config = new DCIImageConfiguration();
        }
    }

    public NetworkMapDCIImage(long id) {
        super(id);
        this.type = 4;
        this.config = new DCIImageConfiguration();
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        msg.setFieldJson(baseId + 10L, this.config);
    }

    public DCIImageConfiguration getImageOptions() {
        return this.config;
    }

    public void setImageOptions(DCIImageConfiguration imageOptions) {
        this.config = imageOptions;
    }
}

