/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Set;
import org.netxms.websvc.json.JsonFilterDummy;
import org.netxms.websvc.json.JsonFilterJsonArray;
import org.netxms.websvc.json.JsonFilterJsonObject;

public abstract class JsonFilter<T> {
    protected T object;
    protected Set<String> fields;

    protected JsonFilter(T object, Set<String> fields) {
        this.object = object;
        this.fields = fields;
    }

    public abstract T filter();

    public static JsonFilter<?> createFilter(Object object, Set<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return new JsonFilterDummy(object, fields);
        }
        if (object instanceof JsonObject) {
            return new JsonFilterJsonObject((JsonObject)object, fields);
        }
        if (object instanceof JsonArray) {
            return new JsonFilterJsonArray((JsonArray)object, fields);
        }
        return new JsonFilterDummy(object, fields);
    }
}

