/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.login;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.base.widgets.QRLabel;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class TwoFactorResponseDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(TwoFactorResponseDialog.class);
    private String challenge;
    private String qrText;
    private boolean trustedDevicesAllowed;
    private String response;
    private boolean trustedDevice;
    private LabeledText responseText;
    private Button checkTrustedDevice;

    public TwoFactorResponseDialog(Shell parentShell, String challenge, String qrText, boolean trustedDevicesAllowed) {
        super(parentShell);
        this.challenge = challenge;
        this.qrText = qrText;
        this.trustedDevicesAllowed = trustedDevicesAllowed;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Two-factor Authentication"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        if (this.qrText != null && !this.qrText.isEmpty()) {
            Label notification = new Label(dialogArea, 0);
            notification.setText(this.i18n.tr("New secret was generated. Please scan it and use for this and subsequent logins."));
            QRLabel qrLabel = new QRLabel(dialogArea, 2048);
            qrLabel.setText(this.qrText);
            GridData gd = new GridData(0x1000000, 0x1000000, true, true);
            gd.minimumWidth = 300;
            gd.minimumHeight = 300;
            qrLabel.setLayoutData((Object)gd);
            PasswordInputField secretText = new PasswordInputField(dialogArea, 0, true);
            secretText.setLabel("Secret as text");
            secretText.setText(this.qrText);
            secretText.setEditable(false);
            gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 400;
            secretText.setLayoutData((Object)gd);
        }
        if (this.challenge != null && !this.challenge.isEmpty()) {
            LabeledText challengeText = new LabeledText(dialogArea, 0);
            challengeText.setLabel(this.i18n.tr("Challenge"));
            challengeText.setText(this.challenge);
            challengeText.getTextControl().setEditable(false);
            challengeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.responseText = new LabeledText(dialogArea, 0);
        this.responseText.setLabel("Response");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 400;
        this.responseText.setLayoutData((Object)gd);
        if (this.trustedDevicesAllowed) {
            this.checkTrustedDevice = new Button(dialogArea, 32);
            this.checkTrustedDevice.setText(this.i18n.tr("&Don't ask again on this computer"));
        }
        this.responseText.setFocus();
        return dialogArea;
    }

    protected void okPressed() {
        this.response = this.responseText.getText().trim();
        this.trustedDevice = this.trustedDevicesAllowed ? this.checkTrustedDevice.getSelection() : false;
        super.okPressed();
    }

    public String getResponse() {
        return this.response;
    }

    public boolean isTrustedDevice() {
        return this.trustedDevice;
    }
}

