/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.helpers.NavigationHistory;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public abstract class ViewContainer
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(ViewContainer.class);
    protected Window window;
    protected Perspective perspective;
    protected MenuManager viewMenuManager;
    protected ToolBarManager viewToolBarManager;
    protected ToolBar viewToolBar;
    protected ToolBar viewControlBar;
    protected ToolItem viewMenu = null;
    protected ToolItem enableFilter = null;
    protected ToolItem navigationBack = null;
    protected ToolItem navigationForward = null;
    protected ToolItem refreshView = null;
    protected Object context;
    protected NavigationHistory navigationHistory = null;
    protected Action showFilterAction;
    protected Runnable onFilterCloseCallback = null;
    protected KeyBindingManager keyBindingManager = new KeyBindingManager();
    protected boolean isActive = true;

    public ViewContainer(Window window, Perspective perspective, Composite parent, int style) {
        super(parent, style);
        this.window = window;
        this.perspective = perspective;
        this.viewMenuManager = new MenuManager();
        this.onFilterCloseCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding(0, 0x1000013, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.showFilterAction = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding("M1+F2", (IAction)this.showFilterAction);
        this.keyBindingManager.addBinding("M1+F", (IAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showViewMenu() {
        if (this.viewMenuManager.isEmpty()) {
            return;
        }
        Menu menu = this.viewMenuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.viewMenu.getBounds();
        menu.setLocation(this.viewControlBar.toDisplay(new Point(bounds.x, bounds.y + bounds.height + 2)));
        menu.setVisible(true);
    }

    protected void updateViewToolBar(View view) {
        this.viewToolBarManager.removeAll();
        view.fillLocalToolBar((IToolBarManager)this.viewToolBarManager);
        this.viewToolBarManager.update(true);
    }

    protected boolean updateViewMenu(View view) {
        boolean changed = false;
        this.viewMenuManager.removeAll();
        view.fillLocalMenu((IMenuManager)this.viewMenuManager);
        if (!this.viewMenuManager.isEmpty()) {
            if (this.viewMenu == null) {
                this.viewMenu = new ToolItem(this.viewControlBar, 8, this.viewControlBar.getItemCount());
                this.viewMenu.setImage(SharedIcons.IMG_VIEW_MENU);
                this.viewMenu.setToolTipText(this.i18n.tr("View menu (F10)"));
                this.viewMenu.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
                changed = true;
            }
        } else if (this.viewMenu != null) {
            this.viewMenu.dispose();
            this.viewMenu = null;
            changed = true;
        }
        return changed;
    }

    public NavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    protected void updateNavigationControls() {
        if (this.navigationForward != null) {
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
        }
        if (this.navigationBack != null) {
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
    }

    protected void navigateBack() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoBackward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getActiveView()).setSelection(this.navigationHistory.back());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    protected void navigateForward() {
        if (this.navigationHistory == null || !this.navigationHistory.canGoForward()) {
            return;
        }
        this.navigationHistory.lock();
        ((NavigationView)this.getActiveView()).setSelection(this.navigationHistory.forward());
        this.navigationHistory.unlock();
        this.navigationBack.setEnabled(this.navigationHistory.canGoBackward());
        this.navigationForward.setEnabled(this.navigationHistory.canGoForward());
    }

    protected void updateRefreshActionState() {
        if (this.refreshView != null) {
            View view = this.getActiveView();
            this.refreshView.setEnabled(view != null && view.isRefreshEnabled());
        }
    }

    public void processKeyStroke(KeyStroke ks) {
        if (this.keyBindingManager.processKeyStroke(ks)) {
            return;
        }
        View view = this.getActiveView();
        if (view != null) {
            view.processKeyStroke(ks);
        }
    }

    protected void refreshActiveView() {
        if (this.refreshView != null && !this.refreshView.isEnabled()) {
            return;
        }
        View view = this.getActiveView();
        if (view != null) {
            view.refresh();
        }
    }

    protected void pinActiveView(PinLocation location) {
        View view = this.getActiveView();
        if (view != null) {
            this.pinView(view, location);
        }
    }

    protected void pinView(View view, PinLocation location) {
        View clone = view.cloneView();
        if (clone != null) {
            Registry.getMainWindow().pinView(clone, location);
        }
    }

    protected void extractActiveView() {
        View view = this.getActiveView();
        if (view != null) {
            this.extractView(view);
        }
    }

    protected void extractView(View view) {
        View clone = view.cloneView();
        if (clone != null) {
            PopOutViewWindow.open((View)clone);
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (active) {
            View view = this.getActiveView();
            if (view != null) {
                view.activate();
            }
        } else {
            View view = this.getActiveView();
            if (view != null) {
                view.deactivate();
            }
        }
    }

    protected abstract View getActiveView();

    public abstract boolean isViewActive(View var1);

    public Window getWindow() {
        return this.window;
    }

    public Perspective getPerspective() {
        return this.perspective;
    }
}

