/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.actions.ExportConversationAction;
import org.netxms.nxmc.modules.ai.widgets.AiAssistantChatWidget;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class AiAssistantChatView
extends View {
    private final I18n i18n = LocalizationHelper.getI18n(AiAssistantChatView.class);
    private long boundIncidentId;
    private AiAssistantChatWidget chatWidget;
    private Action actionClearChat;
    private Action actionExportConversation;

    public AiAssistantChatView() {
        super(LocalizationHelper.getI18n(AiAssistantChatView.class).tr("AI Assistant"), SharedIcons.AI_ASSISTANT, "tools.ai-assistant", false);
        this.boundIncidentId = 0L;
    }

    public AiAssistantChatView(long incidentId) {
        super(LocalizationHelper.getI18n(AiAssistantChatView.class).tr("AI Assistant - Incident #{0}", (Object)incidentId), SharedIcons.AI_ASSISTANT, "tools.ai-assistant." + incidentId, false);
        this.boundIncidentId = incidentId;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        this.chatWidget.createChatSession(false);
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.chatWidget = new AiAssistantChatWidget(parent, 0, (View)this, this.boundIncidentId, false);
        this.createActions();
    }

    protected void postContentCreate() {
        this.chatWidget.createChatSession(true);
    }

    private void createActions() {
        this.actionClearChat = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearChat);
        this.actionExportConversation = new ExportConversationAction((View)this, this.chatWidget);
        this.addKeyBinding("M1+M2+E", (IAction)this.actionExportConversation);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportConversation);
        manager.add((IAction)this.actionClearChat);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportConversation);
        manager.add((IAction)this.actionClearChat);
    }

    public void setFocus() {
        this.chatWidget.getChatInput().setFocus();
    }
}

