/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.widgets;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.ai.AiMessage;
import org.netxms.client.constants.AiMessageStatus;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.widgets.helpers.AiMessageListComparator;
import org.netxms.nxmc.modules.ai.widgets.helpers.AiMessageListFilter;
import org.netxms.nxmc.modules.ai.widgets.helpers.AiMessageListLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AiMessageList
extends Composite {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_TITLE = 3;
    public static final int COLUMN_RELATED_OBJECT = 4;
    public static final int COLUMN_CREATED = 5;
    public static final int COLUMN_EXPIRES = 6;
    private final I18n i18n = LocalizationHelper.getI18n(AiMessageList.class);
    private View view;
    private NXCSession session;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private AiMessageListFilter filter;
    private Map<Long, AiMessage> messages = new HashMap();
    private Action actionMarkRead;
    private Action actionApprove;
    private Action actionReject;
    private Action actionDelete;
    private Consumer<AiMessage> selectionHandler;
    private Consumer<AiMessage> messageUpdateHandler;

    public AiMessageList(View view, Composite parent, int style, String configPrefix) {
        super(parent, style);
        this.view = view;
        this.session = Registry.getSession();
        this.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("Type"), this.i18n.tr("Status"), this.i18n.tr("Title"), this.i18n.tr("Related Object"), this.i18n.tr("Created"), this.i18n.tr("Expires")};
        int[] columnWidths = new int[]{70, 80, 80, 300, 150, 150, 150};
        this.viewer = new SortableTableViewer((Composite)this, columnNames, columnWidths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        AiMessageListLabelProvider labelProvider = new AiMessageListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new AiMessageListComparator());
        this.filter = new AiMessageListFilter(labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refresh();
    }

    private void createActions() {
        this.actionMarkRead = new /* Unavailable Anonymous Inner Class!! */;
        this.actionApprove = new /* Unavailable Anonymous Inner Class!! */;
        this.actionReject = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.updateActionStates();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener & Serializable)manager -> this.fillContextMenu(manager));
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionMarkRead);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionApprove);
        manager.add((IAction)this.actionReject);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
    }

    private void updateActionStates() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean singleSelection = selection.size() == 1;
        AiMessage selectedMessage = singleSelection ? (AiMessage)selection.getFirstElement() : null;
        boolean isPendingApproval = selectedMessage != null && selectedMessage.isApprovalRequest() && selectedMessage.getStatus() == AiMessageStatus.PENDING;
        this.actionMarkRead.setEnabled(hasSelection);
        this.actionApprove.setEnabled(isPendingApproval);
        this.actionReject.setEnabled(isPendingApproval);
        this.actionDelete.setEnabled(hasSelection);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateMessageList() {
        this.viewer.setInput((Object)this.messages.values().toArray());
    }

    public void setSelectionHandler(Consumer<AiMessage> handler) {
        this.selectionHandler = handler;
    }

    public void setMessageUpdateHandler(Consumer<AiMessage> handler) {
        this.messageUpdateHandler = handler;
    }

    private void markSelectedAsRead() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] selectedMessages = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void approveSelected() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        this.approveMessage((AiMessage)selection.getFirstElement());
    }

    private void approveMessage(AiMessage message) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void rejectSelected() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        this.rejectMessage((AiMessage)selection.getFirstElement());
    }

    private void rejectMessage(AiMessage message) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteSelected() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)this.i18n.tr("Confirm Delete"), (String)this.i18n.tr("Do you really want to delete selected message(s)?"))) {
            return;
        }
        Object[] selectedMessages = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public AiMessageListFilter getFilter() {
        return this.filter;
    }

    public Action getActionMarkRead() {
        return this.actionMarkRead;
    }

    public Action getActionApprove() {
        return this.actionApprove;
    }

    public Action getActionReject() {
        return this.actionReject;
    }

    public Action getActionDelete() {
        return this.actionDelete;
    }
}

