/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.widgets.LocalFileSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ImportDashboardDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(ImportDashboardDialog.class);
    private String objectName;
    private File importFile;
    private LabeledText textName;
    private LocalFileSelector importFileSelector;

    public ImportDashboardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Import Dashboard"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.i18n.tr("Object name"));
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.textName.setLayoutData((Object)gd);
        this.importFileSelector = new LocalFileSelector(dialogArea, 0, false, 4096);
        this.importFileSelector.setLabel(this.i18n.tr("Import file"));
        this.importFileSelector.setFilterExtensions(new String[]{"*.xml", "*.*"});
        this.importFileSelector.setFilterNames(new String[]{this.i18n.tr("XML files"), this.i18n.tr("All files")});
        this.importFileSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.importFileSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.objectName = this.textName.getText();
        this.importFile = this.importFileSelector.getFile();
        if (this.importFile == null) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select dashboard definition file"));
            return;
        }
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public File getImportFile() {
        return this.importFile;
    }
}

