/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.AlarmViewerConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class AlarmViewer
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(AlarmViewer.class);
    private static final String[] STATE_NAME = new String[]{LocalizationHelper.getI18n(AlarmViewer.class).tr("Outstanding"), LocalizationHelper.getI18n(AlarmViewer.class).tr("Acknowledged"), LocalizationHelper.getI18n(AlarmViewer.class).tr("Resolved")};
    private AlarmViewerConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Button[] checkSeverity;
    private Button[] checkState;
    private Button checkEnableLocalSound;

    public AlarmViewer(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(AlarmViewer.class).tr("Alarm Viewer"), elementConfig);
    }

    public String getId() {
        return "alarm-viewer";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof AlarmViewerConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (AlarmViewerConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Root object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        Group severityGroup = new Group(dialogArea, 0);
        severityGroup.setText(this.i18n.tr("Severity filter"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        severityGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        severityGroup.setLayout((Layout)layout);
        this.checkSeverity = new Button[5];
        for (int severity = 4; severity >= 0; --severity) {
            this.checkSeverity[severity] = new Button((Composite)severityGroup, 32);
            this.checkSeverity[severity].setText(StatusDisplayInfo.getStatusText((int)severity));
            this.checkSeverity[severity].setSelection((this.config.getSeverityFilter() & 1 << severity) != 0);
        }
        Group stateGroup = new Group(dialogArea, 0);
        stateGroup.setText(this.i18n.tr("State filter"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        stateGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        stateGroup.setLayout((Layout)layout);
        this.checkState = new Button[3];
        for (int i = 0; i < 3; ++i) {
            this.checkState[i] = new Button((Composite)stateGroup, 32);
            this.checkState[i].setText(STATE_NAME[i]);
            this.checkState[i].setSelection((this.config.getStateFilter() & 1 << i) != 0);
        }
        this.checkEnableLocalSound = new Button(dialogArea, 32);
        this.checkEnableLocalSound.setText(this.i18n.tr("Play alarm sounds when active"));
        this.checkEnableLocalSound.setSelection(this.config.getIsLocalSoundEnabled());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        int severityFilter = 0;
        for (int i = 0; i < this.checkSeverity.length; ++i) {
            if (!this.checkSeverity[i].getSelection()) continue;
            severityFilter |= 1 << i;
        }
        this.config.setSeverityFilter(severityFilter);
        int stateFilter = 0;
        for (int i = 0; i < this.checkState.length; ++i) {
            if (!this.checkState[i].getSelection()) continue;
            stateFilter |= 1 << i;
        }
        this.config.setStateFilter(stateFilter);
        this.config.setIsLocalSoundEnabled(this.checkEnableLocalSound.getSelection());
        return true;
    }
}

