/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableValueConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.datacollection.widgets.DciTemplateSelectionWidget;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableValue
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(TableValue.class);
    private TableValueConfig config;
    private DciSelector dciSelector;
    private DciTemplateSelectionWidget templateDciWidget;
    private TitleConfigurator title;
    private Spinner refreshRate;
    private Combo sortColumn;
    private Button sortDirectionAscending;
    private Button sortDirectionDescending;

    public TableValue(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(TableValue.class).tr("Table Value"), elementConfig);
    }

    public String getId() {
        return "table-value";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof TableValueConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (TableValueConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.dciSelector = new DciSelector(dialogArea, 0, true);
        this.dciSelector.setLabel(this.i18n.tr("Table DCI"));
        this.dciSelector.setDcObjectType(2);
        this.dciSelector.setDciId(this.config.getObjectId(), this.config.getDciId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dciSelector.setLayoutData((Object)gd);
        this.dciSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.templateDciWidget = new DciTemplateSelectionWidget(dialogArea, 0);
        this.templateDciWidget.setConfig(this.config.getTemplateConfig());
        this.templateDciWidget.setMultiMatchVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.templateDciWidget.setLayoutData((Object)gd);
        this.templateDciWidget.setEnabled(this.config.getObjectId() == 0xFFFFFFFFL);
        Group goupSortingOrder = new Group(dialogArea, 0);
        goupSortingOrder.setText("Sorting order");
        layout = new GridLayout();
        layout.marginTop = 4;
        layout.marginBottom = 8;
        layout.marginWidth = 4;
        layout.numColumns = 2;
        goupSortingOrder.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        goupSortingOrder.setLayoutData((Object)gd);
        this.sortDirectionAscending = new Button((Composite)goupSortingOrder, 16);
        this.sortDirectionAscending.setText(this.i18n.tr("Ascending"));
        this.sortDirectionAscending.setSelection(this.config.getSortDirection() == 128);
        this.sortDirectionAscending.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sortDirectionDescending = new Button((Composite)goupSortingOrder, 16);
        this.sortDirectionDescending.setText(this.i18n.tr("Descending"));
        this.sortDirectionDescending.setSelection(this.config.getSortDirection() == 1024);
        this.sortDirectionDescending.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.sortColumn = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)0, (String)this.i18n.tr("Sort column"), (Object)gd);
        if (this.config.getObjectId() != 0xFFFFFFFFL && this.config.getObjectId() != 0L && this.config.getDciId() != 0L) {
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Refresh interval (seconds)"), (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.dciSelector.getNodeId());
        this.config.setDciId(this.dciSelector.getDciId());
        this.config.applyTemplateConfig(this.templateDciWidget.getConfig());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setSortColumn(this.sortColumn.getText());
        this.config.setSortDirection(this.sortDirectionAscending.getSelection() ? 128 : 1024);
        return true;
    }
}

