/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedPieChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ScriptedComparisonChartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedPieChartElement
extends ScriptedComparisonChartElement {
    private static final Logger logger = LoggerFactory.getLogger(ScriptedPieChartElement.class);
    private ScriptedPieChartConfig elementConfig;

    public ScriptedPieChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.elementConfig = (ScriptedPieChartConfig)new Gson().fromJson(element.getData(), ScriptedPieChartConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new ScriptedPieChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        this.script = this.elementConfig.getScript();
        this.objectId = this.getEffectiveObjectId(this.elementConfig.getObjectId());
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setExtendedLegend(this.elementConfig.isExtendedLegend());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        chartConfig.setDoughnutRendering(this.elementConfig.isDoughnutRendering());
        chartConfig.setShowTotal(this.elementConfig.isShowTotal());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.PIE, chartConfig, (View)view);
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.chart.rebuild();
        this.startRefreshTimer();
    }
}

