/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.base.widgets.ExtendedColorSelector;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.tools.ColorConverter;
import org.xnap.commons.i18n.I18n;

public class TitleConfigurator
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(TitleConfigurator.class);
    private Text text;
    private ExtendedColorSelector backgroundColor;
    private ExtendedColorSelector foregroundColor;
    private LabeledSpinner fontHeight;
    private LabeledText fontName;

    public TitleConfigurator(Composite parent, DashboardElementConfig config) {
        this(parent, config, false);
    }

    public TitleConfigurator(Composite parent, DashboardElementConfig config, boolean standalone) {
        super(parent, 0);
        Composite group;
        this.setLayout((Layout)new FillLayout());
        if (standalone) {
            group = new Composite((Composite)this, 0);
        } else {
            group = new Group((Composite)this, 0);
            ((Group)group).setText(this.i18n.tr("Title"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        if (standalone) {
            Label label = new Label(group, 0);
            label.setText(this.i18n.tr("Title"));
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = layout.numColumns;
            label.setLayoutData((Object)gd);
        }
        this.text = new Text(group, 2048);
        this.text.setText(config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.text.setLayoutData((Object)gd);
        this.backgroundColor = this.createColorSelector(group, this.i18n.tr("Background"));
        this.backgroundColor.setColorValue(ColorConverter.parseColorDefinition((String)config.getTitleBackground()));
        this.backgroundColor.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        this.foregroundColor = this.createColorSelector(group, this.i18n.tr("Foreground"));
        this.foregroundColor.setColorValue(ColorConverter.parseColorDefinition((String)config.getTitleForeground()));
        this.foregroundColor.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        this.fontHeight = new LabeledSpinner(group, 0);
        this.fontHeight.setLabel("Font size adjustment");
        this.fontHeight.setRange(-20, 20);
        this.fontHeight.setSelection(config.getTitleFontSize());
        this.fontHeight.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fontName = new LabeledText(group, 0);
        this.fontName.setLabel(this.i18n.tr("Font name"));
        this.fontName.setText(config.getTitleFontName() != null ? config.getTitleFontName() : "");
        this.fontName.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private ExtendedColorSelector createColorSelector(Composite parent, String name) {
        ExtendedColorSelector selector = new ExtendedColorSelector(parent);
        selector.setLabels(name, this.i18n.tr("Default"), this.i18n.tr("Custom"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        selector.setLayoutData((Object)gd);
        return selector;
    }

    public void updateConfiguration(DashboardElementConfig config) {
        config.setTitle(this.text.getText());
        config.setTitleBackground(ColorConverter.rgbToCss((RGB)this.backgroundColor.getColorValue()));
        config.setTitleForeground(ColorConverter.rgbToCss((RGB)this.foregroundColor.getColorValue()));
        config.setTitleFontSize(this.fontHeight.getSelection());
        config.setTitleFontName(this.fontName.getText());
    }
}

