/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventSelectionDialog;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class EventSelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(EventSelector.class);
    private int eventCode = 0;
    private String eventName = null;

    public EventSelector(Composite parent, int style) {
        this(parent, style, new SelectorConfigurator());
    }

    public EventSelector(Composite parent, int style, SelectorConfigurator configurator) {
        super(parent, style, configurator.setSelectionButtonToolTip(LocalizationHelper.getI18n(EventSelector.class).tr("Select event")));
        this.setText(this.i18n.tr("None"));
    }

    protected void selectionButtonHandler() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            int prevEventCode = this.eventCode;
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.eventName = events[0].getName();
                this.setText(events[0].getName());
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)events[0].getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(events[0]));
            } else {
                this.eventCode = 0;
                this.eventName = null;
                this.setText(this.i18n.tr("None"));
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
            if (prevEventCode != this.eventCode) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.eventCode == 0) {
            return;
        }
        this.eventCode = 0;
        this.eventName = null;
        this.setText(this.i18n.tr("None"));
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventCode(int eventCode) {
        if (this.eventCode == eventCode) {
            return;
        }
        this.eventCode = eventCode;
        if (eventCode != 0) {
            EventTemplate evt = Registry.getSession().findEventTemplateByCode(eventCode);
            if (evt != null) {
                this.eventName = evt.getName();
                this.setText(this.eventName);
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)evt.getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(evt));
            } else {
                this.setText("[" + eventCode + "]");
                this.setImage(StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.UNKNOWN));
                this.getTextControl().setToolTipText(null);
            }
        } else {
            this.eventName = null;
            this.setText(this.i18n.tr("None"));
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
        this.fireModifyListeners();
    }

    private String generateToolTipText(EventTemplate evt) {
        StringBuilder sb = new StringBuilder(evt.getName());
        sb.append(" [");
        sb.append(evt.getCode());
        sb.append("] ");
        sb.append(StatusDisplayInfo.getStatusText((Severity)evt.getSeverity()));
        sb.append("\n\n");
        sb.append(evt.getMessage());
        sb.append("\n\n");
        sb.append(evt.getDescription().replace("\r", ""));
        return sb.toString();
    }
}

