/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CreateIncidentDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(CreateIncidentDialog.class);
    private static final String CONFIG_PREFIX = "CreateIncidentDialog";
    private ObjectSelector objectSelector;
    private LabeledText titleField;
    private LabeledText initialCommentField;
    private long objectId;
    private String title;
    private String initialComment;

    public CreateIncidentDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Incident"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("CreateIncidentDialog.cx", 500), settings.getAsInteger("CreateIncidentDialog.cy", 400));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        this.objectSelector.setLabel(this.i18n.tr("Source Object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.titleField = new LabeledText(dialogArea, 0);
        this.titleField.setLabel(this.i18n.tr("Title"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.titleField.setLayoutData((Object)gd);
        this.initialCommentField = new LabeledText(dialogArea, 0, 2818);
        this.initialCommentField.setLabel(this.i18n.tr("Initial comment"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.initialCommentField.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.objectId = this.objectSelector.getObjectId();
        if (this.objectId == 0L) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select source object"));
            return;
        }
        this.title = this.titleField.getText().trim();
        if (this.title.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter incident title"));
            return;
        }
        this.initialComment = this.initialCommentField.getText().trim();
        if (this.initialComment.isEmpty()) {
            this.initialComment = null;
        }
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("CreateIncidentDialog.cx", size.x);
        settings.set("CreateIncidentDialog.cy", size.y);
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInitialComment() {
        return this.initialComment;
    }
}

