/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class EditIncidentCommentDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EditIncidentCommentDialog.class);
    private static final String CONFIG_PREFIX = "EditIncidentCommentDialog";
    private LabeledText textControl;
    private String text;
    private String initialText;
    private String customTitle;
    private String customLabel;

    public EditIncidentCommentDialog(Shell parentShell, String initialText) {
        this(parentShell, initialText, null, null);
    }

    public EditIncidentCommentDialog(Shell parentShell, String initialText, String customTitle, String customLabel) {
        super(parentShell);
        this.initialText = initialText;
        this.customTitle = customTitle;
        this.customLabel = customLabel;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.customTitle != null) {
            newShell.setText(this.customTitle);
        } else {
            newShell.setText(this.initialText != null ? this.i18n.tr("Edit Comment") : this.i18n.tr("Add Comment"));
        }
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("EditIncidentCommentDialog.cx", 400), settings.getAsInteger("EditIncidentCommentDialog.cy", 350));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.textControl = new LabeledText(dialogArea, 0, 2818);
        this.textControl.setLabel(this.customLabel != null ? this.customLabel : this.i18n.tr("Comment"));
        if (this.initialText != null) {
            this.textControl.setText(this.initialText);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textControl.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.text = this.textControl.getText().trim();
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("EditIncidentCommentDialog.cx", size.x);
        settings.set("EditIncidentCommentDialog.cy", size.y);
    }

    public String getText() {
        return this.text;
    }
}

