/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.widgets;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.constants.IncidentState;
import org.netxms.client.events.IncidentSummary;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.incidents.dialogs.CreateIncidentDialog;
import org.netxms.nxmc.modules.incidents.dialogs.EditIncidentCommentDialog;
import org.netxms.nxmc.modules.incidents.widgets.helpers.IncidentComparator;
import org.netxms.nxmc.modules.incidents.widgets.helpers.IncidentListFilter;
import org.netxms.nxmc.modules.incidents.widgets.helpers.IncidentListLabelProvider;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class IncidentList
extends Composite {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_TITLE = 2;
    public static final int COLUMN_SOURCE_OBJECT = 3;
    public static final int COLUMN_ASSIGNED_USER = 4;
    public static final int COLUMN_CREATED_TIME = 5;
    public static final int COLUMN_LAST_CHANGE_TIME = 6;
    public static final int COLUMN_ALARMS = 7;
    private final I18n i18n = LocalizationHelper.getI18n(IncidentList.class);
    private View view;
    private NXCSession session;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private IncidentListFilter filter;
    private Map<Long, IncidentSummary> incidents = new HashMap();
    private Action actionCreate;
    private Action actionBlock;
    private Action actionInProgress;
    private Action actionResolve;
    private Action actionReopen;
    private Action actionClose;
    private Action actionAssign;
    private Action actionAddComment;

    public IncidentList(View view, Composite parent, int style, String configPrefix) {
        super(parent, style);
        this.view = view;
        this.session = Registry.getSession();
        this.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("State"), this.i18n.tr("Title"), this.i18n.tr("Source"), this.i18n.tr("Assignee"), this.i18n.tr("Created"), this.i18n.tr("Last Change"), this.i18n.tr("Alarms")};
        int[] columnWidths = new int[]{80, 100, 300, 150, 120, 150, 150, 70};
        this.viewer = new SortableTableViewer((Composite)this, columnNames, columnWidths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IncidentListLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new IncidentComparator());
        this.filter = new IncidentListFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refresh();
    }

    private void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionBlock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionInProgress = new /* Unavailable Anonymous Inner Class!! */;
        this.actionResolve = new /* Unavailable Anonymous Inner Class!! */;
        this.actionReopen = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClose = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAssign = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddComment = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener & Serializable)manager -> this.fillContextMenu(manager));
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInProgress);
        manager.add((IAction)this.actionBlock);
        manager.add((IAction)this.actionResolve);
        manager.add((IAction)this.actionReopen);
        manager.add((IAction)this.actionClose);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAssign);
        manager.add((IAction)this.actionAddComment);
    }

    private void updateActionStates() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean singleSelection = selection.size() == 1;
        IncidentSummary selectedIncident = singleSelection ? (IncidentSummary)selection.getFirstElement() : null;
        IncidentState state = selectedIncident != null ? selectedIncident.getState() : null;
        boolean canBlock = singleSelection && state != null && state != IncidentState.BLOCKED && state != IncidentState.RESOLVED && state != IncidentState.CLOSED;
        boolean canSetInProgress = singleSelection && (state == IncidentState.OPEN || state == IncidentState.BLOCKED);
        boolean canResolve = hasSelection;
        boolean canReopen = singleSelection && state == IncidentState.RESOLVED;
        this.actionBlock.setEnabled(canBlock);
        this.actionInProgress.setEnabled(canSetInProgress);
        this.actionResolve.setEnabled(canResolve);
        this.actionReopen.setEnabled(canReopen);
        this.actionClose.setEnabled(hasSelection);
        this.actionAssign.setEnabled(singleSelection);
        this.actionAddComment.setEnabled(singleSelection);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createIncident() {
        CreateIncidentDialog dialog = new CreateIncidentDialog(this.getShell());
        if (dialog.open() == 0) {
            long objectId = dialog.getObjectId();
            String title = dialog.getTitle();
            String initialComment = dialog.getInitialComment();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void blockIncident() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        IncidentSummary incident = (IncidentSummary)selection.getFirstElement();
        EditIncidentCommentDialog dialog = new EditIncidentCommentDialog(this.getShell(), null, this.i18n.tr("Block Incident"), this.i18n.tr("Reason for blocking"));
        if (dialog.open() != 0) {
            return;
        }
        String comment = dialog.getText();
        if (comment.trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Comment is required when blocking an incident"));
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void changeIncidentState(IncidentState newState) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        IncidentSummary incident = (IncidentSummary)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void resolveIncidents() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Resolve Incidents"), (String)this.i18n.tr("Are you sure you want to resolve selected incident(s)? All linked alarms will also be resolved."))) {
            return;
        }
        Object[] selectedIncidents = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void closeIncidents() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Close Incidents"), (String)this.i18n.tr("Are you sure you want to close selected incident(s)?"))) {
            return;
        }
        Object[] selectedIncidents = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void assignIncident() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        IncidentSummary incident = (IncidentSummary)selection.getFirstElement();
        UserSelectionDialog dialog = new UserSelectionDialog(this.getShell(), User.class);
        dialog.enableMultiSelection(false);
        if (dialog.open() != 0) {
            return;
        }
        int userId = dialog.getSelection()[0].getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addComment() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        IncidentSummary incident = (IncidentSummary)selection.getFirstElement();
        EditIncidentCommentDialog dialog = new EditIncidentCommentDialog(this.getShell(), null);
        if (dialog.open() == 0) {
            String comment = dialog.getText();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public IncidentListFilter getFilter() {
        return this.filter;
    }

    public Action getActionCreate() {
        return this.actionCreate;
    }
}

