/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.services.NetworkMapImageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapImageProvidersManager {
    private static final Logger logger = LoggerFactory.getLogger(MapImageProvidersManager.class);
    private static MapImageProvidersManager instance = new MapImageProvidersManager();
    private List<NetworkMapImageProvider> providers = new ArrayList(0);

    public static MapImageProvidersManager getInstance() {
        return instance;
    }

    private MapImageProvidersManager() {
        ServiceLoader<NetworkMapImageProvider> loader = ServiceLoader.load(NetworkMapImageProvider.class, this.getClass().getClassLoader());
        for (NetworkMapImageProvider p : loader) {
            logger.debug("Adding network map image provider " + p.getDescription());
            this.providers.add(p);
        }
        this.providers.sort(new /* Unavailable Anonymous Inner Class!! */);
    }

    public Image getMapImage(AbstractObject object) {
        for (NetworkMapImageProvider p : this.providers) {
            Image i = p.getMapImage(object);
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public Image getStatusIcon(ObjectStatus status) {
        for (NetworkMapImageProvider p : this.providers) {
            Image i = p.getStatusIcon(status);
            if (i == null) continue;
            return i;
        }
        return null;
    }
}

