/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.dialogs.EditDCIImageRuleDialog;
import org.netxms.nxmc.modules.networkmaps.propertypages.helpers.DCIImageRuleLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DCIImageRules
extends PropertyPage {
    public static final int COLUMN_OPERATION = 0;
    public static final int COLUMN_COMMENT = 1;
    private static final String COLUMN_SETTINGS_PREFIX = "DCIImageRuleList.ImageRuleList";
    private I18n i18n = LocalizationHelper.getI18n(DCIImageRules.class);
    private NetworkMapDCIImage container;
    private DCIImageConfiguration config;
    private List<DCIImageRule> rules;
    private TableViewer viewer;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public DCIImageRules(NetworkMapDCIImage dciImage) {
        super(LocalizationHelper.getI18n(DCIImageRules.class).tr("Rules"));
        this.container = dciImage;
    }

    protected Control createContents(Composite parent) {
        this.config = this.container.getImageOptions();
        this.rules = this.config.getRulesAsList();
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite RuleArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        RuleArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        RuleArea.setLayout((Layout)layout);
        new Label(RuleArea, 0).setText(this.i18n.tr("Rules"));
        this.viewer = new TableViewer(RuleArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.setupRuleList();
        this.viewer.setInput((Object)this.rules.toArray());
        Composite leftButtons = new Composite(RuleArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("Dow&n"));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(RuleArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(this.i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void deleteRules() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.rules.remove(it.next());
            }
            this.viewer.setInput((Object)this.rules.toArray());
        }
    }

    private void editRule() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            DCIImageRule rule = (DCIImageRule)selection.getFirstElement();
            EditDCIImageRuleDialog dlg = new EditDCIImageRuleDialog(this.getShell(), rule);
            if (dlg.open() == 0) {
                this.viewer.update((Object)rule, null);
            }
        }
    }

    private void addRule() {
        DCIImageRule rule = new DCIImageRule();
        EditDCIImageRuleDialog dlg = new EditDCIImageRuleDialog(this.getShell(), rule);
        if (dlg.open() == 0) {
            this.rules.add(rule);
            this.viewer.setInput((Object)this.rules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void moveUp() {
        DCIImageRule rule;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.rules.indexOf(rule = (DCIImageRule)selection.getFirstElement())) > 0) {
            Collections.swap(this.rules, index - 1, index);
            this.viewer.setInput((Object)this.rules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void moveDown() {
        DCIImageRule rule;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.rules.indexOf(rule = (DCIImageRule)selection.getFirstElement())) < this.rules.size() - 1 && index >= 0) {
            Collections.swap(this.rules, index + 1, index);
            this.viewer.setInput((Object)this.rules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)rule));
        }
    }

    private void setupRuleList() {
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Expression"));
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Comments"));
        column.setWidth(150);
        WidgetHelper.restoreColumnSettings((Table)table, (String)COLUMN_SETTINGS_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DCIImageRuleLabelProvider());
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isControlCreated()) {
            return true;
        }
        this.config.setDciRuleArray(this.rules.toArray(new DCIImageRule[this.rules.size()]));
        this.saveSettings();
        return true;
    }

    public boolean performCancel() {
        if (!this.isControlCreated()) {
            return true;
        }
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

