/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.CreateInterfaceDciDialog;
import org.netxms.nxmc.modules.objects.dialogs.helpers.InterfaceDciInfo;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateInterfaceDciDialog
extends Dialog {
    private static final boolean[] DEFAULT_ENABLED = new boolean[]{true, true, false, false, false, false, false, false};
    private final I18n i18n = LocalizationHelper.getI18n(CreateInterfaceDciDialog.class);
    private final String[] names = new String[]{this.i18n.tr("Inbound traffic (bytes)"), this.i18n.tr("Outbound traffic (bytes)"), this.i18n.tr("Inbound traffic (bits)"), this.i18n.tr("Outbound traffic (bits)"), this.i18n.tr("Inbound traffic (packets)"), this.i18n.tr("Outbound traffic (packets)"), this.i18n.tr("Input errors"), this.i18n.tr("Output errors")};
    private final String[] descriptions = new String[]{this.i18n.tr("Inbound traffic on @@ifName@@"), this.i18n.tr("Outbound traffic on @@ifName@@"), this.i18n.tr("Inbound traffic on @@ifName@@"), this.i18n.tr("Outbound traffic on @@ifName@@"), this.i18n.tr("Inbound traffic on @@ifName@@"), this.i18n.tr("Outbound traffic on @@ifName@@"), this.i18n.tr("Input error rate on @@ifName@@"), this.i18n.tr("Output error rate on @@ifName@@")};
    private Interface object;
    private InterfaceDciForm[] forms = new InterfaceDciForm[this.names.length];
    private Combo pollingScheduleTypeSelector;
    private LabeledText textInterval;
    private Combo retentionTypeSelector;
    private LabeledText textRetention;
    private int pollingScheduleType;
    private int pollingInterval;
    private int retentionType;
    private int retentionTime;
    private InterfaceDciInfo[] dciInfo;

    public CreateInterfaceDciDialog(Shell parentShell, Interface object) {
        super(parentShell);
        this.object = object;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Interface DCI"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        PreferenceStore settings = PreferenceStore.getInstance();
        boolean[] enabled = new boolean[DEFAULT_ENABLED.length];
        boolean[] delta = new boolean[DEFAULT_ENABLED.length];
        for (int i = 0; i < enabled.length; ++i) {
            enabled[i] = settings.getAsBoolean("CreateInterfaceDciDialog.enabled_" + i, DEFAULT_ENABLED[i]);
            delta[i] = settings.getAsBoolean("CreateInterfaceDciDialog.delta_" + i, true);
        }
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        Group dataGroup = new Group(dialogArea, 0);
        dataGroup.setText(this.i18n.tr("Data"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        dataGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        dataGroup.setLayout((Layout)layout);
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                Label sep = new Label((Composite)dataGroup, 258);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                sep.setLayoutData((Object)gd);
            }
            this.forms[i] = new InterfaceDciForm(this, (Composite)dataGroup, this.names[i], this.object != null ? this.descriptions[i].replaceAll("@@ifName@@", this.object.getObjectName()) : this.descriptions[i], enabled[i], delta[i]);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.forms[i].setLayoutData((Object)gd);
        }
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        this.pollingScheduleTypeSelector = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)2056, (String)this.i18n.tr("Polling interval"), (Object)"WidgetHelper::default_layout_data");
        this.pollingScheduleTypeSelector.add(this.i18n.tr("Default"));
        this.pollingScheduleTypeSelector.add(this.i18n.tr("Custom"));
        this.pollingScheduleTypeSelector.select(settings.getAsInteger("CreateInterfaceDciDialog.pollingScheduleType", 0));
        this.pollingScheduleTypeSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.retentionTypeSelector = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)2056, (String)this.i18n.tr("Retention time"), (Object)"WidgetHelper::default_layout_data");
        this.retentionTypeSelector.add(this.i18n.tr("Use default retention time"));
        this.retentionTypeSelector.add(this.i18n.tr("Use custom retention time"));
        this.retentionTypeSelector.add(this.i18n.tr("Do not save collected data to database"));
        this.retentionTypeSelector.select(settings.getAsInteger("CreateInterfaceDciDialog.retentionType", 0));
        this.retentionTypeSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textInterval = new LabeledText((Composite)optionsGroup, 0);
        this.textInterval.setLabel(this.i18n.tr("Custom polling interval (seconds)"));
        this.textInterval.setText(Integer.toString(settings.getAsInteger("CreateInterfaceDciDialog.pollingInterval", 60)));
        this.textInterval.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textInterval.setLayoutData((Object)gd);
        this.textInterval.setEnabled(false);
        this.textRetention = new LabeledText((Composite)optionsGroup, 0);
        this.textRetention.setLabel(this.i18n.tr("Custom retention time (days)"));
        this.textRetention.setText(Integer.toString(settings.getAsInteger("CreateInterfaceDciDialog.retentionTime", 30)));
        this.textRetention.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRetention.setLayoutData((Object)gd);
        this.textRetention.setEnabled(false);
        return dialogArea;
    }

    protected void okPressed() {
        PreferenceStore settings = PreferenceStore.getInstance();
        this.pollingScheduleType = this.pollingScheduleTypeSelector.getSelectionIndex();
        try {
            this.pollingInterval = Integer.parseInt(this.textInterval.getText());
            if (this.pollingInterval < 2 || this.pollingInterval > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.pollingScheduleType == 1) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Please enter polling pollingInterval as integer in range 2 .. 10000"));
            }
            this.pollingInterval = 60;
        }
        this.retentionType = this.retentionTypeSelector.getSelectionIndex();
        try {
            this.retentionTime = Integer.parseInt(this.textRetention.getText());
            if (this.retentionTime < 1 || this.retentionTime > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.retentionType == 1) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Please enter retention time as integer in range 1 .. 10000"));
            }
            this.retentionTime = 30;
        }
        settings.set("CreateInterfaceDciDialog.pollingScheduleType", this.pollingScheduleType);
        settings.set("CreateInterfaceDciDialog.pollingInterval", this.pollingInterval);
        settings.set("CreateInterfaceDciDialog.retentionType", this.retentionType);
        settings.set("CreateInterfaceDciDialog.retentionTime", this.retentionTime);
        this.dciInfo = new InterfaceDciInfo[this.forms.length];
        for (int i = 0; i < this.forms.length; ++i) {
            this.dciInfo[i] = new InterfaceDciInfo(this.forms[i].isDciEnabled(), this.forms[i].isDelta(), this.forms[i].getDescription());
            settings.set("CreateInterfaceDciDialog.enabled_" + i, this.forms[i].isDciEnabled());
            settings.set("CreateInterfaceDciDialog.delta_" + i, this.forms[i].isDelta());
            settings.set("CreateInterfaceDciDialog.description_" + i, this.forms[i].getDescription());
        }
        super.okPressed();
    }

    public int getPollingScheduleType() {
        return this.pollingScheduleType;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getRetentionType() {
        return this.retentionType;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public InterfaceDciInfo[] getDciInfo() {
        return this.dciInfo;
    }
}

