/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateNetworkServiceDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(CreateNetworkServiceDialog.class);
    private LabeledText nameField;
    private LabeledText aliasField;
    private Combo serviceTypeField;
    private LabeledText portField;
    private LabeledText requestField;
    private LabeledText responseField;
    private Button checkCreateDci;
    private String name;
    private String alias;
    private int serviceType;
    private int port;
    private String request;
    private String response;
    private boolean createDci;

    public CreateNetworkServiceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Network Service Object"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.serviceTypeField = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Service type"), (Object)gd);
        this.serviceTypeField.add(this.i18n.tr("User-defined"));
        this.serviceTypeField.add(this.i18n.tr("SSH"));
        this.serviceTypeField.add(this.i18n.tr("POP3"));
        this.serviceTypeField.add(this.i18n.tr("SMTP"));
        this.serviceTypeField.add(this.i18n.tr("FTP"));
        this.serviceTypeField.add(this.i18n.tr("HTTP"));
        this.serviceTypeField.add(this.i18n.tr("HTTPS"));
        this.serviceTypeField.add(this.i18n.tr("Telnet"));
        this.serviceTypeField.select(0);
        this.portField = new LabeledText(dialogArea, 0);
        this.portField.setLabel(this.i18n.tr("Port"));
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.requestField = new LabeledText(dialogArea, 0);
        this.requestField.setLabel(this.i18n.tr("Request"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.requestField.setLayoutData((Object)gd);
        this.responseField = new LabeledText(dialogArea, 0);
        this.responseField.setLabel(this.i18n.tr("Response"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.responseField.setLayoutData((Object)gd);
        PreferenceStore settings = PreferenceStore.getInstance();
        this.checkCreateDci = new Button(dialogArea, 32);
        this.checkCreateDci.setText(this.i18n.tr("&Create service status DCI at parent node"));
        this.checkCreateDci.setSelection(settings.getAsBoolean("CreateNetworkServiceDialog.checkCreateDci", false));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkCreateDci.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please provide non-empty object name"));
            return;
        }
        this.serviceType = this.serviceTypeField.getSelectionIndex();
        try {
            this.port = Integer.parseInt(this.portField.getText());
            if (this.port < 1 || this.port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid port number (1 .. 65535)"));
            return;
        }
        this.alias = this.aliasField.getText().trim();
        this.request = this.requestField.getText();
        this.response = this.responseField.getText();
        this.createDci = this.checkCreateDci.getSelection();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("CreateNetworkServiceDialog.checkCreateDci", this.createDci);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean isCreateDci() {
        return this.createDci;
    }
}

