/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.IcmpStatCollectionMode;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class ICMP
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(ICMP.class);
    private AbstractNode node;
    private ObjectSelector icmpProxy;
    private Button radioIcmpStatCollectionDefault;
    private Button radioIcmpStatCollectionOn;
    private Button radioIcmpStatCollectionOff;
    private TableViewer icmpTargets;
    private Set<InetAddress> icmpTargetSet = new HashSet();

    public ICMP(AbstractObject object) {
        super(LocalizationHelper.getI18n(ICMP.class).tr("ICMP"), object);
    }

    public String getId() {
        return "communication.icmp";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        this.icmpTargetSet.addAll(Arrays.asList(this.node.getIcmpTargets()));
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.icmpProxy = new ObjectSelector(dialogArea, 0, true);
        this.icmpProxy.setLabel(this.i18n.tr("Proxy"));
        this.icmpProxy.setObjectId(this.node.getIcmpProxyId());
        this.icmpProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group statCollectionGroup = new Group(dialogArea, 0);
        statCollectionGroup.setText("ICMP response statistic collection");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        statCollectionGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        statCollectionGroup.setLayoutData((Object)gd);
        this.radioIcmpStatCollectionDefault = new Button((Composite)statCollectionGroup, 16);
        this.radioIcmpStatCollectionDefault.setText(this.i18n.tr("De&fault"));
        this.radioIcmpStatCollectionDefault.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.DEFAULT);
        this.radioIcmpStatCollectionOn = new Button((Composite)statCollectionGroup, 16);
        this.radioIcmpStatCollectionOn.setText(this.i18n.tr("On"));
        this.radioIcmpStatCollectionOn.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.ON);
        this.radioIcmpStatCollectionOff = new Button((Composite)statCollectionGroup, 16);
        this.radioIcmpStatCollectionOff.setText(this.i18n.tr("Off"));
        this.radioIcmpStatCollectionOff.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.OFF);
        Group icmpTargetGroup = new Group(dialogArea, 0);
        icmpTargetGroup.setText("Additional targets for ICMP response statistic collection");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        icmpTargetGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        icmpTargetGroup.setLayout((Layout)layout);
        this.icmpTargets = new TableViewer((Composite)icmpTargetGroup, 67586);
        this.icmpTargets.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.icmpTargets.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.icmpTargets.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.icmpTargets.setInput((Object)this.icmpTargetSet.toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.icmpTargets.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)icmpTargetGroup, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.icmpTargets.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setIcmpProxy(this.icmpProxy.getObjectId());
        md.setIcmpTargets((Collection)this.icmpTargetSet);
        IcmpStatCollectionMode mode = this.radioIcmpStatCollectionOff.getSelection() ? IcmpStatCollectionMode.OFF : (this.radioIcmpStatCollectionOn.getSelection() ? IcmpStatCollectionMode.ON : IcmpStatCollectionMode.DEFAULT);
        md.setIcmpStatCollectionMode(mode);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.icmpProxy.setObjectId(0L);
    }
}

