/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardTemplate;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class Polling
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(Polling.class);
    private PollingTarget pollingTarget;
    private ObjectSelector pollerNode;
    private Button radioIfXTableDefault;
    private Button radioIfXTableEnable;
    private Button radioIfXTableDisable;
    private Button radioAgentCacheDefault;
    private Button radioAgentCacheOn;
    private Button radioAgentCacheOff;
    private LabeledSpinner pollCount;
    private List<Button> flagButtons = new ArrayList();
    private List<Integer> flagValues = new ArrayList();

    public Polling(AbstractObject object) {
        super(LocalizationHelper.getI18n(Polling.class).tr("Polling"), object);
    }

    public String getId() {
        return "polling";
    }

    public int getPriority() {
        return 20;
    }

    public boolean isVisible() {
        return this.object instanceof PollingTarget && !(this.object instanceof Container) && !(this.object instanceof Dashboard) && !(this.object instanceof DashboardTemplate) && !(this.object instanceof Template) && !(this.object instanceof BusinessServicePrototype) && !(this.object instanceof NetworkMap);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.pollingTarget = (PollingTarget)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        if (this.pollingTarget.canHavePollerNode()) {
            Group servicePollGroup = new Group(dialogArea, 0);
            servicePollGroup.setText(this.i18n.tr("Network service polling"));
            layout = new GridLayout();
            layout.horizontalSpacing = 5;
            layout.numColumns = 2;
            servicePollGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            servicePollGroup.setLayoutData((Object)gd);
            this.pollerNode = new ObjectSelector((Composite)servicePollGroup, 0, true);
            this.pollerNode.setLabel(this.i18n.tr("Poller node"));
            this.pollerNode.setObjectClass(AbstractNode.class);
            this.pollerNode.setEmptySelectionName(this.i18n.tr("<server>"));
            this.pollerNode.setObjectId(this.pollingTarget.getPollerNodeId());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.pollerNode.setLayoutData((Object)gd);
            Label label = new Label((Composite)servicePollGroup, 64);
            label.setText(this.i18n.tr("All network services of this node will be polled from poller node specified here, if not overriden by network service settings."));
            gd = new GridData();
            gd.widthHint = 250;
            label.setLayoutData((Object)gd);
        }
        if (this.object instanceof AbstractNode) {
            this.pollCount = new LabeledSpinner(dialogArea, 0);
            this.pollCount.setLabel("Required poll count for status change");
            this.pollCount.setSelection(((AbstractNode)this.object).getRequredPollCount());
        }
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        if (this.pollingTarget.canHaveAgent()) {
            this.addFlag((Composite)optionsGroup, 0x100000, this.i18n.tr("Disable usage of NetXMS &agent for all polls"));
        }
        if (this.pollingTarget.canHaveInterfaces()) {
            this.addFlag((Composite)optionsGroup, 524288, this.i18n.tr("Disable usage of &SNMP for all polls"));
            this.addFlag((Composite)optionsGroup, 0x200000, this.i18n.tr("Disable usage of &ICMP pings for status polling"));
            this.addFlag((Composite)optionsGroup, 0x40000000, this.i18n.tr("Disable SS&H usage for all polls"));
            this.addFlag((Composite)optionsGroup, 32768, this.i18n.tr("Disable &VNC detection"));
            this.addFlag((Composite)optionsGroup, 16384, this.i18n.tr("Disable reading of SM-CLP available properties metadata"));
        }
        if (this.pollingTarget.canUseEtherNetIP()) {
            this.addFlag((Composite)optionsGroup, 0x8000000, this.i18n.tr("Disable usage of &EtherNet/IP for all polls"));
        }
        if (this.pollingTarget.canUseModbus()) {
            this.addFlag((Composite)optionsGroup, Integer.MIN_VALUE, this.i18n.tr("Disable usage of &Modbus for all polls"));
        }
        this.addFlag((Composite)optionsGroup, 1, this.i18n.tr("Disable s&tatus polling"));
        if (this.pollingTarget.canHaveInterfaces()) {
            this.addFlag((Composite)optionsGroup, 0x20000000, "Disable &802.1x port state checking during status poll");
        }
        this.addFlag((Composite)optionsGroup, 2, this.i18n.tr("Disable &configuration polling"));
        if (this.pollingTarget.canHaveInterfaces()) {
            this.addFlag((Composite)optionsGroup, 0x800000, this.i18n.tr("Disable &routing table polling"));
            this.addFlag((Composite)optionsGroup, 262144, this.i18n.tr("Disable to&pology polling"));
            this.addFlag((Composite)optionsGroup, 131072, this.i18n.tr("Disable network &discovery polling"));
        }
        if (this.pollingTarget instanceof DataCollectionTarget) {
            this.addFlag((Composite)optionsGroup, 4, this.i18n.tr("Disable data c&ollection"));
        }
        if (this.pollingTarget.canHaveAgent()) {
            this.addFlag((Composite)optionsGroup, 0x10000000, "Disable reading of &Windows performance counters metadata");
        }
        if (this.pollingTarget.canHaveInterfaces()) {
            Group ifXTableGroup = new Group(dialogArea, 0);
            ifXTableGroup.setText(this.i18n.tr("Use ifXTable for interface polling"));
            layout = new GridLayout();
            layout.horizontalSpacing = 5;
            layout.numColumns = 3;
            layout.makeColumnsEqualWidth = true;
            ifXTableGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            ifXTableGroup.setLayoutData((Object)gd);
            this.radioIfXTableDefault = new Button((Composite)ifXTableGroup, 16);
            this.radioIfXTableDefault.setText(this.i18n.tr("De&fault"));
            this.radioIfXTableDefault.setSelection(this.pollingTarget.getIfXTablePolicy() == 0);
            this.radioIfXTableEnable = new Button((Composite)ifXTableGroup, 16);
            this.radioIfXTableEnable.setText(this.i18n.tr("&Enable"));
            this.radioIfXTableEnable.setSelection(this.pollingTarget.getIfXTablePolicy() == 1);
            this.radioIfXTableDisable = new Button((Composite)ifXTableGroup, 16);
            this.radioIfXTableDisable.setText(this.i18n.tr("&Disable"));
            this.radioIfXTableDisable.setSelection(this.pollingTarget.getIfXTablePolicy() == 2);
        }
        if (this.pollingTarget.canHaveAgent()) {
            Group agentCacheGroup = new Group(dialogArea, 0);
            agentCacheGroup.setText(this.i18n.tr("Agent cache mode"));
            layout = new GridLayout();
            layout.horizontalSpacing = 5;
            layout.numColumns = 3;
            layout.makeColumnsEqualWidth = true;
            agentCacheGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            agentCacheGroup.setLayoutData((Object)gd);
            this.radioAgentCacheDefault = new Button((Composite)agentCacheGroup, 16);
            this.radioAgentCacheDefault.setText(this.i18n.tr("De&fault"));
            this.radioAgentCacheDefault.setSelection(this.pollingTarget.getAgentCacheMode() == AgentCacheMode.DEFAULT);
            this.radioAgentCacheOn = new Button((Composite)agentCacheGroup, 16);
            this.radioAgentCacheOn.setText(this.i18n.tr("On"));
            this.radioAgentCacheOn.setSelection(this.pollingTarget.getAgentCacheMode() == AgentCacheMode.ON);
            this.radioAgentCacheOff = new Button((Composite)agentCacheGroup, 16);
            this.radioAgentCacheOff.setText(this.i18n.tr("Off"));
            this.radioAgentCacheOff.setSelection(this.pollingTarget.getAgentCacheMode() == AgentCacheMode.OFF);
        }
        return dialogArea;
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setSelection((this.pollingTarget.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectNodeFlags() {
        int flags = this.pollingTarget.getFlags();
        for (int i = 0; i < this.flagButtons.size(); ++i) {
            if (((Button)this.flagButtons.get(i)).getSelection()) {
                flags |= ((Integer)this.flagValues.get(i)).intValue();
                continue;
            }
            flags &= ~((Integer)this.flagValues.get(i)).intValue();
        }
        return flags;
    }

    private int collectNodeFlagsMask() {
        int mask = 0;
        for (int i = 0; i < this.flagButtons.size(); ++i) {
            mask |= ((Integer)this.flagValues.get(i)).intValue();
        }
        return mask;
    }

    private int collectIfXTablePolicy() {
        if (this.radioIfXTableEnable.getSelection()) {
            return 1;
        }
        if (this.radioIfXTableDisable.getSelection()) {
            return 2;
        }
        return 0;
    }

    private AgentCacheMode collectAgentCacheMode() {
        if (this.radioAgentCacheOn.getSelection()) {
            return AgentCacheMode.ON;
        }
        if (this.radioAgentCacheOff.getSelection()) {
            return AgentCacheMode.OFF;
        }
        return AgentCacheMode.DEFAULT;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        if (this.pollingTarget.canHavePollerNode()) {
            md.setPollerNode(this.pollerNode.getObjectId());
        }
        md.setObjectFlags(this.collectNodeFlags(), this.collectNodeFlagsMask());
        if (this.pollingTarget.canHaveInterfaces()) {
            md.setIfXTablePolicy(this.collectIfXTablePolicy());
        }
        if (this.pollingTarget.canHaveAgent()) {
            md.setAgentCacheMode(this.collectAgentCacheMode());
        }
        if (this.pollingTarget instanceof AbstractNode) {
            md.setRequiredPolls(this.pollCount.getSelection());
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.pollerNode.setObjectId(0L);
        this.radioIfXTableDefault.setSelection(true);
        this.radioIfXTableDisable.setSelection(false);
        this.radioIfXTableEnable.setSelection(false);
        for (Button b : this.flagButtons) {
            b.setSelection(false);
        }
    }
}

