/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceControllerComparator;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceControllerLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class RadioInterfacesController
extends NodeSubObjectTableView {
    private final I18n i18n = LocalizationHelper.getI18n(RadioInterfacesController.class);
    public static final int COLUMN_AP_NAME = 0;
    public static final int COLUMN_AP_MAC_ADDR = 1;
    public static final int COLUMN_AP_VENDOR = 2;
    public static final int COLUMN_AP_MODEL = 3;
    public static final int COLUMN_AP_SERIAL = 4;
    public static final int COLUMN_INDEX = 5;
    public static final int COLUMN_NAME = 6;
    public static final int COLUMN_SSID = 7;
    public static final int COLUMN_BSSID = 8;
    public static final int COLUMN_NIC_VENDOR = 9;
    public static final int COLUMN_BAND = 10;
    public static final int COLUMN_CHANNEL = 11;
    public static final int COLUMN_FREQUENCY = 12;
    public static final int COLUMN_TX_POWER_DBM = 13;
    public static final int COLUMN_TX_POWER_MW = 14;

    public RadioInterfacesController() {
        super(LocalizationHelper.getI18n(RadioInterfacesController.class).tr("Radios"), ResourceManager.getImageDescriptor((String)"icons/object-views/radio_interfaces.png"), "objects.controller-radios", false);
    }

    public int getPriority() {
        return 53;
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractNode && ((AbstractNode)context).isWirelessController();
    }

    protected void createViewer() {
        String[] names = new String[]{this.i18n.tr("AP Name"), this.i18n.tr("AP MAC Address"), this.i18n.tr("AP Vendor"), this.i18n.tr("AP Model"), this.i18n.tr("AP Serial"), this.i18n.tr("Radio Index"), this.i18n.tr("Radio Name"), this.i18n.tr("SSID"), this.i18n.tr("BSSID"), this.i18n.tr("NIC vendor"), this.i18n.tr("Band"), this.i18n.tr("Channel"), this.i18n.tr("Frequency"), this.i18n.tr("Tx Power dBm"), this.i18n.tr("Tx Power mW")};
        int[] widths = new int[]{120, 100, 140, 140, 100, 90, 120, 120, 100, 200, 90, 90, 90, 90, 90};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RadioInterfaceControllerLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new RadioInterfaceControllerComparator());
        this.createPopupMenu();
    }

    public void refresh() {
        if (this.getObject() == null) {
            this.viewer.setInput((Object)new RadioInterface[0]);
            return;
        }
        ArrayList<RadioInterface> list = new ArrayList<RadioInterface>();
        for (AbstractObject o : this.getObject().getAllChildren(33)) {
            for (RadioInterface rif : ((AccessPoint)o).getRadios()) {
                list.add(rif);
            }
        }
        this.viewer.setInput(list);
        this.viewer.packColumns();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof AccessPoint && object.isChildOf(this.getObjectId());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }
}

