/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.configs.ChassisPlacement;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.objects.widgets.ChassisWidget;
import org.netxms.nxmc.modules.objects.widgets.ObjectPopupDialog;
import org.netxms.nxmc.modules.objects.widgets.RackWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.WidgetHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChassisWidget
extends Canvas
implements PaintListener,
DisposeListener,
ImageUpdateListener,
MouseListener,
MouseTrackListener {
    private static final int FULL_UNIT_WIDTH = 482;
    private static final int FULL_UNIT_HEIGHT = 45;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int TITLE_HEIGHT = 20;
    private static final int STATUS_INDECATOR_HEIGHT = 3;
    private static final int STATUS_INDECATOR_WIDTH = 8;
    private static final int STATUS_INDECATOR_SHIFT = 2;
    private static final int STATUS_INDECATOR_BORDER = 1;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", ".AppleSystemUIFont", "Verdana", "Arial"};
    private static final String[] VIEW_LABELS = new String[]{"Front", "Back"};
    private Chassis chassis;
    private Font[] titleFonts;
    private List<ObjectImage> objects = new ArrayList();
    private Object selectedObject = null;
    private Set<ElementSelectionListener> selectionListeners = new HashSet(0);
    private Object tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;
    private RackOrientation view;

    public ChassisWidget(Composite parent, int style, Chassis chassis, RackOrientation view, boolean separateView) {
        super(parent, style | 0x20000000);
        this.chassis = chassis;
        this.view = view == RackOrientation.FILL ? RackOrientation.FRONT : view;
        this.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.titleFonts = FontTools.getFonts((String[])FONT_NAMES, (int)6, (int)1, (int)16);
        this.addPaintListener((PaintListener)this);
        this.addMouseListener((MouseListener)this);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)this);
        this.addDisposeListener((DisposeListener)this);
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
    }

    public Object getCurrentObject() {
        return this.selectedObject;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setAntialias(1);
        WidgetHelper.setHighInterpolation((GC)gc);
        Rectangle rect = this.getClientArea();
        rect.x += 10;
        rect.y += 30;
        rect.height -= 40;
        rect.width -= 20;
        if (rect.height <= 0 || rect.width <= 0) {
            return;
        }
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.titleFonts, (String)VIEW_LABELS[0], (int)rect.width, (int)20));
        Point titleSize = gc.textExtent(VIEW_LABELS[this.view.getValue() - 1]);
        gc.drawText(VIEW_LABELS[this.view.getValue() - 1], rect.width / 2 - titleSize.x / 2 + 10, rect.y - 20 - 5);
        ChassisWidget.drawChassis((GC)gc, (Rectangle)rect, (Chassis)this.chassis, (RackOrientation)this.view, (ObjectRegistration)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void drawChassis(GC gc, Rectangle rect, Chassis chassis, RackOrientation view, ObjectRegistration objectRegistration) {
        UUID imageGuid;
        Image image = view == RackOrientation.REAR ? RackWidget.getImageDefaultRear() : RackWidget.getImageDefaultTop();
        UUID uUID = imageGuid = view == RackOrientation.FRONT ? chassis.getFrontRackImage() : chassis.getRearRackImage();
        if (!imageGuid.equals(NXCommon.EMPTY_GUID)) {
            image = ImageProvider.getInstance().getImage(imageGuid);
        }
        Rectangle r = image.getBounds();
        if (chassis.getRackHeight() == 1 || !imageGuid.equals(NXCommon.EMPTY_GUID)) {
            gc.drawImage(image, 0, 0, r.width, r.height, rect.x, rect.y, rect.width, rect.height);
        } else {
            Image imageMiddle = view == RackOrientation.REAR ? RackWidget.getImageDefaultRear() : RackWidget.getImageDefaultMiddle();
            Image imageBottom = view == RackOrientation.REAR ? RackWidget.getImageDefaultRear() : RackWidget.getImageDefaultBottom();
            int oneUnitHeight = rect.height / chassis.getRackHeight();
            gc.drawImage(image, 0, 0, r.width, r.height, rect.x, rect.y, rect.width, oneUnitHeight);
            r = imageMiddle.getBounds();
            for (int i = 1; i < chassis.getRackHeight() - 1; ++i) {
                gc.drawImage(imageMiddle, 0, 0, r.width, r.height, rect.x, rect.y + oneUnitHeight * i, rect.width, oneUnitHeight);
            }
            r = imageBottom.getBounds();
            gc.drawImage(imageBottom, 0, 0, r.width, r.height, rect.x, rect.y + oneUnitHeight * (chassis.getRackHeight() - 1), rect.width, oneUnitHeight);
        }
        double proportion = (double)rect.height / (double)(45 * chassis.getRackHeight());
        Color gray = gc.getDevice().getSystemColor(15);
        Color black = gc.getDevice().getSystemColor(2);
        for (AbstractObject object : chassis.getChildrenAsArray()) {
            ChassisPlacement placemet;
            if (!(object instanceof Node) || (placemet = ((Node)object).getChassisPlacement()).getOritentaiton() != view.getValue()) continue;
            Rectangle unitRect = new Rectangle(rect.x + (int)(placemet.getPositionWidthInMm() * proportion), rect.y + (int)(placemet.getPositionHeightInMm() * proportion), (int)(placemet.getWidthInMm() * proportion), (int)(placemet.getHeightInMm() * proportion));
            if (unitRect.width <= 0 || unitRect.height <= 0) continue;
            if (objectRegistration != null) {
                objectRegistration.addObject((Object)object, unitRect);
            }
            boolean imageMissing = true;
            imageGuid = placemet.getImage();
            if (!imageGuid.equals(NXCommon.EMPTY_GUID)) {
                image = null;
                image = ImageProvider.getInstance().getImage(imageGuid);
                if (image != null) {
                    r = image.getBounds();
                    gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                    imageMissing = false;
                }
            }
            if (imageMissing) {
                gc.setBackground(gray);
                gc.fillRectangle(unitRect);
            }
            gc.setBackground(black);
            gc.fillRectangle(unitRect.x + 2, unitRect.y + 2, (int)(8.0 * proportion + 2.0), (int)(3.0 * proportion + 2.0));
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus()));
            gc.fillRectangle(unitRect.x + 2 + 1, unitRect.y + 2 + 1, (int)(8.0 * proportion), (int)(3.0 * proportion));
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint == -1 && wHint == -1) {
            return new Point(10, 10);
        }
        int titleSize = 40;
        hHint /= 2;
        hHint -= titleSize;
        wHint -= 20;
        int realHeight = 45 * this.chassis.getRackHeight();
        if (482.0 / (double)realHeight >= (double)wHint / (double)hHint) {
            hHint = wHint * realHeight / 482;
        } else {
            wHint = hHint * 482 / realHeight;
        }
        return new Point(wHint + 20, hHint + titleSize);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.removePaintListener((PaintListener)this);
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
    }

    public void imageUpdated(UUID guid) {
        boolean found = false;
        for (AbstractObject obj : this.chassis.getChildrenAsArray()) {
            if (!guid.equals(((Node)obj).getChassisPlacement().getImage())) continue;
            found = true;
            break;
        }
        if (found) {
            this.redraw();
        }
    }

    private Object getObjectAtPoint(Point p) {
        for (ObjectImage i : this.objects) {
            if (!i.contains(p)) continue;
            return i.getObject();
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
        this.setCurrentObject(this.getObjectAtPoint(new Point(e.x, e.y)));
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
    }

    public void mouseHover(MouseEvent e) {
        Object object = this.getObjectAtPoint(new Point(e.x, e.y));
        if (object != null && (object != this.tooltipObject || this.tooltipDialog == null || this.tooltipDialog.getShell() == null || this.tooltipDialog.getShell().isDisposed())) {
            if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
                this.tooltipDialog.close();
            }
            this.tooltipObject = object;
            this.tooltipDialog = new ObjectPopupDialog(this.getShell(), object, this.toDisplay(e.x, e.y));
            this.tooltipDialog.open();
        } else if (object == null && this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
    }

    public void addSelectionListener(ElementSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ElementSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void setCurrentObject(Object o) {
        this.selectedObject = o;
        for (ElementSelectionListener l : this.selectionListeners) {
            l.objectSelected(this.selectedObject);
        }
    }
}

