/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.InputField;
import org.netxms.client.NXCException;
import org.netxms.client.constants.InputFieldType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.dialogs.InputFieldEntryDialog;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.modules.objecttools.views.MultiNodeCommandExecutor;
import org.netxms.nxmc.modules.objecttools.views.helpers.ExecutorListLabelProvider;
import org.netxms.nxmc.modules.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ActionExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.LocalCommandExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.SSHExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ServerCommandExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ServerScriptExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.helpers.ExecutorStateChangeListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class MultiNodeCommandExecutor
extends ObjectView {
    private I18n i18n = LocalizationHelper.getI18n(MultiNodeCommandExecutor.class);
    private SashForm splitter;
    private SortableTableViewer viewer;
    private Composite resultArea;
    private List<AbstractObjectToolExecutor> executors = new ArrayList();
    private AbstractObjectToolExecutor currentExecutor = null;
    private AbstractObjectToolExecutor.ActionSet actions;
    private AbstractObjectToolExecutor.CommonContext objectToolInfo;
    private Set<ObjectContext> applicableObjects;
    private Set<ObjectContext> sourceObjects;
    private List<String> restoredApplicableObjects;
    private List<String> restoredSourceObjects;
    private boolean viewRestored = false;
    private boolean askInputValues = false;

    public MultiNodeCommandExecutor(ObjectTool tool, Set<ObjectContext> sourceObjects, Set<ObjectContext> nodes, Map<String, String> inputValues, List<String> maskedFields) {
        super(tool.getDisplayName(), ResourceManager.getImageDescriptor((String)"icons/object-tools/terminal.png"), nodes.toString() + tool.getId(), false);
        this.applicableObjects = nodes;
        this.objectToolInfo = new AbstractObjectToolExecutor.CommonContext(tool, inputValues, maskedFields);
        this.sourceObjects = sourceObjects;
    }

    protected MultiNodeCommandExecutor() {
        super(null, ResourceManager.getImageDescriptor((String)"icons/object-tools/terminal.png"), null, false);
    }

    public View cloneView() {
        MultiNodeCommandExecutor view = (MultiNodeCommandExecutor)super.cloneView();
        view.applicableObjects = this.applicableObjects;
        view.objectToolInfo = new AbstractObjectToolExecutor.CommonContext(this.objectToolInfo);
        view.sourceObjects = this.sourceObjects;
        return view;
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.splitter = new SashForm(parent, 512);
        Composite topPart = new Composite((Composite)this.splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topPart.setLayout((Layout)layout);
        String[] names = new String[]{"Name", "Status"};
        int[] widths = new int[]{600, 200};
        this.viewer = new SortableTableViewer(topPart, names, widths, 0, 1024, 65536);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExecutorListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(topPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite bottomPart = new Composite((Composite)this.splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        bottomPart.setLayout((Layout)layout);
        new Label(bottomPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        this.resultArea = new Composite(bottomPart, 0);
        this.resultArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    protected void postClone(View origin) {
        MultiNodeCommandExecutor view = (MultiNodeCommandExecutor)origin;
        for (AbstractObjectToolExecutor e : view.executors) {
            ActionExecutor executor = switch (this.objectToolInfo.tool.getToolType()) {
                case 1 -> new ActionExecutor(this.resultArea, e.getContext(), this.actions, this.objectToolInfo);
                case 5 -> new LocalCommandExecutor(this.resultArea, e.getContext(), this.actions, this.objectToolInfo);
                case 6 -> new ServerCommandExecutor(this.resultArea, e.getContext(), this.actions, this.objectToolInfo);
                case 10 -> new SSHExecutor(this.resultArea, e.getContext(), this.actions, this.objectToolInfo);
                case 8 -> new ServerScriptExecutor(this.resultArea, e.getContext(), this.actions, this.objectToolInfo);
                default -> null;
            };
            executor.addStateChangeListener((ExecutorStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            executor.onClone(e);
            this.executors.add(executor);
        }
        this.viewer.setInput((Object)this.executors.toArray());
        this.viewer.getTable().setSelection(0);
        this.onSelectionChange();
        super.postClone((View)view);
    }

    protected void postContentCreate() {
        if (!this.viewRestored) {
            this.execute();
        } else {
            this.restoreState();
        }
        super.postContentCreate();
    }

    private void restoreContextObjects(Set<ObjectContext> destinationList, List<String> sourceList) throws IOException, NXCException, NumberFormatException {
        for (String s : sourceList) {
            String[] elements = s.split(":");
            if (elements.length != 4 || !elements[0].equals("ObjectContext")) continue;
            long objectId = Long.parseLong(elements[1]);
            long alarmId = Long.parseLong(elements[2]);
            long contextId = Long.parseLong(elements[3]);
            destinationList.add(new ObjectContext(this.session.findObjectById(objectId), alarmId > 0L ? this.session.getAlarm(alarmId) : null, contextId));
        }
    }

    public void restoreState() {
        this.applicableObjects = new HashSet();
        this.sourceObjects = new HashSet();
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void createActions() {
        this.actions = new AbstractObjectToolExecutor.ActionSet();
        this.actions.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actions.actionScrollLock.setChecked(false);
        this.actions.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionCopy.setEnabled(false);
        this.actions.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionRestart.setEnabled(false);
        this.actions.actionTerminate = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionTerminate.setEnabled(false);
    }

    private void onSelectionChange() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection == null) {
            return;
        }
        AbstractObjectToolExecutor executor = (AbstractObjectToolExecutor)selection.getFirstElement();
        if (this.currentExecutor != executor) {
            if (this.currentExecutor != null) {
                this.currentExecutor.hide();
            }
            this.currentExecutor = executor;
            if (this.currentExecutor != null) {
                this.currentExecutor.show();
            }
        }
    }

    public void execute() {
        this.executors.clear();
        this.createExecutors(true);
    }

    private void createExecutors(boolean execute) {
        for (ObjectContext ctx : this.applicableObjects) {
            ActionExecutor executor = switch (this.objectToolInfo.tool.getToolType()) {
                case 1 -> new ActionExecutor(this.resultArea, ctx, this.actions, this.objectToolInfo);
                case 5 -> new LocalCommandExecutor(this.resultArea, ctx, this.actions, this.objectToolInfo);
                case 6 -> new ServerCommandExecutor(this.resultArea, ctx, this.actions, this.objectToolInfo);
                case 10 -> new SSHExecutor(this.resultArea, ctx, this.actions, this.objectToolInfo);
                case 8 -> new ServerScriptExecutor(this.resultArea, ctx, this.actions, this.objectToolInfo);
                default -> null;
            };
            executor.addStateChangeListener((ExecutorStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.executors.add(executor);
            if (!execute) continue;
            executor.execute();
        }
        this.viewer.setInput((Object)this.executors.toArray());
        this.viewer.getTable().setSelection(0);
        this.onSelectionChange();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof AbstractObject && this.sourceObjects.size() > 0) {
            for (ObjectContext object : this.sourceObjects) {
                if (((AbstractObject)context).getObjectId() != object.object.getObjectId()) continue;
                return true;
            }
            if (((AbstractObject)context).getObjectId() == ((ObjectContext)this.sourceObjects.iterator().next()).contextId) {
                return true;
            }
        }
        return false;
    }

    public boolean isCloseable() {
        return true;
    }

    private boolean restoreUserInputFields() {
        if (!this.askInputValues) {
            return true;
        }
        InputField[] fields = this.objectToolInfo.tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, (f1, f2) -> f1.getSequence() - f2.getSequence());
            InputFieldEntryDialog dlg = new InputFieldEntryDialog(this.getWindow().getShell(), this.objectToolInfo.tool.getDisplayName(), fields, this.objectToolInfo.inputValues);
            if (dlg.open() != 0) {
                return false;
            }
            this.objectToolInfo.inputValues = dlg.getValues();
            this.objectToolInfo.maskedFields.clear();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != InputFieldType.PASSWORD) continue;
                this.objectToolInfo.maskedFields.add(fields[i].getName());
            }
        }
        this.askInputValues = false;
        return true;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("inputValues.keys", this.objectToolInfo.inputValues.keySet());
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry v : this.objectToolInfo.inputValues.entrySet()) {
            if (this.objectToolInfo.maskedFields.contains(v.getKey())) {
                values.add("");
                continue;
            }
            values.add((String)v.getValue());
        }
        memento.set("inputValues.values", values);
        if (this.objectToolInfo.maskedFields != null) {
            memento.set("maskedFields", (Collection)this.objectToolInfo.maskedFields);
        }
        memento.set("tool", this.objectToolInfo.tool.getId());
        memento.set("applicableObjects", (Collection)this.applicableObjects);
        memento.set("sourceObjects", (Collection)this.sourceObjects);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        List keys = memento.getAsStringList("inputValues.keys");
        List values = memento.getAsStringList("inputValues.values");
        HashMap<String, String> inputValues = new HashMap<String, String>();
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            inputValues.put((String)keys.get(i), (String)values.get(i));
        }
        List maskedFields = memento.getAsStringList("maskedFields");
        long id = memento.getAsLong("tool", 0L);
        ObjectTool tool = ObjectToolsCache.getInstance().findTool(id);
        if (tool == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid tool id"));
        }
        this.objectToolInfo = new AbstractObjectToolExecutor.CommonContext(tool, inputValues, maskedFields);
        this.setName(tool.getDisplayName());
        this.askInputValues = this.objectToolInfo.maskedFields.size() > 0;
        this.viewRestored = true;
        this.restoredApplicableObjects = memento.getAsStringList("applicableObjects");
        this.restoredSourceObjects = memento.getAsStringList("sourceObjects");
    }
}

