/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.ComparatorHelper;
import org.xnap.commons.i18n.I18n;

public class AddressListElementComparator
extends ViewerComparator {
    private I18n i18n = LocalizationHelper.getI18n(AddressListElementComparator.class);
    private NXCSession session = Registry.getSession();
    private boolean isDiscoveryTarget;

    public AddressListElementComparator(boolean isDiscoveryTarget) {
        this.isDiscoveryTarget = isDiscoveryTarget;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        InetAddressListElement a1 = (InetAddressListElement)e1;
        InetAddressListElement a2 = (InetAddressListElement)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)a1.getBaseAddress(), (InetAddress)a2.getBaseAddress());
                if (result != 0 || (result = a1.getType() - a2.getType()) != 0) break;
                result = a1.getType() == 0 ? a1.getMaskBits() - a2.getMaskBits() : ComparatorHelper.compareInetAddresses((InetAddress)a1.getEndAddress(), (InetAddress)a2.getEndAddress());
                break;
            }
            case 1: {
                if (this.isDiscoveryTarget) {
                    String name1 = this.session.getZoneName(a1.getZoneUIN());
                    String name2 = this.session.getZoneName(a2.getZoneUIN());
                    result = name1.compareTo(name2);
                    break;
                }
                result = a1.getComment().compareTo(a2.getComment());
                break;
            }
            case 2: {
                String name1 = a1.getProxyId() != 0L ? this.session.getObjectName(a1.getProxyId()) : this.i18n.tr("Zone proxy");
                String name2 = a2.getProxyId() != 0L ? this.session.getObjectName(a2.getProxyId()) : this.i18n.tr("Zone proxy");
                result = name1.compareTo(name2);
                break;
            }
            case 3: {
                result = a1.getComment().compareTo(a2.getComment());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

