/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.actions.CreateSnmpDci;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.modules.snmp.helpers.SnmpValueLabelProvider;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.netxms.nxmc.modules.snmp.views.MibExplorer;
import org.netxms.nxmc.modules.snmp.views.helpers.SnmpWalkFilter;
import org.netxms.nxmc.modules.snmp.widgets.MibBrowser;
import org.netxms.nxmc.modules.snmp.widgets.MibObjectDetails;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MibExplorer
extends AdHocObjectView
implements SnmpWalkListener {
    private I18n i18n = LocalizationHelper.getI18n(MibExplorer.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TEXT = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VALUE = 3;
    public static final int COLUMN_RAW_VALUE = 4;
    private MibBrowser mibBrowser;
    private MibObjectDetails details;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private SnmpValueLabelProvider valuesLabelProvider;
    private boolean walkActive = false;
    private long walkObjectId = 0L;
    private List<SnmpValue> walkData = new ArrayList();
    private String restoredSelection;
    private Action actionWalk;
    private Action actionCopyObjectName;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopySymbolicName;
    private Action actionCopyType;
    private Action actionCopyValue;
    private Action actionCopyRawValue;
    private Action actionSelect;
    private Action actionExportToCsv;
    private Action actionShowResultFilter;
    private Action actionShortTextualNames;
    private CreateSnmpDci actionCreateSnmpDci;
    private Composite resultArea;
    private SnmpWalkFilter filter;
    private boolean toolView;

    public MibExplorer(long objectId, long context, boolean toolView) {
        super(LocalizationHelper.getI18n(MibExplorer.class).tr("MIB Explorer"), ResourceManager.getImageDescriptor((String)"icons/object-views/mibexplorer.gif"), toolView ? "tools.mib-explorer" : "objects.mib-explorer", objectId, context, false);
        this.toolView = toolView;
    }

    protected MibExplorer() {
        this(0L, 0L, false);
    }

    public View cloneView() {
        MibExplorer view = (MibExplorer)super.cloneView();
        view.toolView = this.toolView;
        return view;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        MibExplorer view = (MibExplorer)origin;
        if (!view.walkActive) {
            this.walkData.addAll(view.walkData);
            this.viewer.setInput((Object)this.walkData);
            this.viewer.packColumns();
        }
        this.mibBrowser.getTreeViewer().setExpandedElements(view.mibBrowser.getTreeViewer().getVisibleExpandedElements());
        this.mibBrowser.getTreeViewer().setSelection(view.mibBrowser.getTreeViewer().getSelection());
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.toolView) {
            Group selectorArea = new Group(parent, 0);
            selectorArea.setText(this.i18n.tr("Context"));
            selectorArea.setLayout((Layout)new GridLayout());
            selectorArea.setLayoutData((Object)new GridData(4, 4, true, false));
            ObjectSelector objectSelector = new ObjectSelector((Composite)selectorArea, 0, new SelectorConfigurator().setShowClearButton(true).setShowLabel(false));
            objectSelector.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            objectSelector.setObjectClass(Node.class);
            objectSelector.setLayoutData((Object)new GridData(4, 4, true, false));
            objectSelector.addModifyListener((ModifyListener & Serializable)e -> {
                AbstractObject object = objectSelector.getObject();
                this.setObjectId(object != null ? object.getObjectId() : 0L);
                this.setContext((Object)object);
            });
        }
        SashForm splitter = new SashForm(parent, 512);
        splitter.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = this.toolView ? 3 : 0;
        splitter.setLayoutData((Object)gd);
        SashForm mibViewSplitter = new SashForm((Composite)splitter, 256);
        mibViewSplitter.setLayout((Layout)new FillLayout());
        this.mibBrowser = new MibBrowser((Composite)mibViewSplitter, 2048);
        this.mibBrowser.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.details = new MibObjectDetails((Composite)mibViewSplitter, 2048, true, this.mibBrowser, (Consumer)new /* Unavailable Anonymous Inner Class!! */);
        this.resultArea = new Composite((Composite)splitter, 2048);
        this.resultArea.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.resultArea, 0);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filterText.setCloseCallback(() -> this.showResultFilter(false));
        this.viewer = new SortableTableViewer(this.resultArea, 65538);
        this.setupViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valuesLabelProvider = new SnmpValueLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.valuesLabelProvider);
        this.filter = new SnmpWalkFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener(e -> this.selectInTree());
        this.viewer.setInput((Object)this.walkData);
        splitter.setWeights(new int[]{70, 30});
        this.createActions();
        this.createTreeContextMenu();
        this.createResultsPopupMenu();
        boolean shortTextualNames = PreferenceStore.getInstance().getAsBoolean(this.getBaseId() + ".shortTextualNames", true);
        this.actionShortTextualNames.setChecked(shortTextualNames);
        this.valuesLabelProvider.setShortTextualNames(shortTextualNames);
        boolean showResultFilter = PreferenceStore.getInstance().getAsBoolean(this.getBaseId() + ".showResultFilter", true);
        this.filterText.setVisible(showResultFilter);
        this.actionShowResultFilter.setChecked(showResultFilter);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = showResultFilter ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        if (this.restoredSelection != null && !this.restoredSelection.isBlank()) {
            this.details.setOid(this.restoredSelection);
            this.restoredSelection = null;
        } else {
            AbstractObject object = this.getObject();
            if (object != null && object instanceof Node) {
                this.details.setOid(((Node)object).getSnmpOID());
            }
        }
    }

    public void showResultFilter(boolean show) {
        this.filterText.setVisible(show);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = show ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.getClientArea().layout(true, true);
        if (show) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        PreferenceStore.getInstance().set(this.getBaseId() + ".showResultFilter", show);
    }

    public void refresh() {
        this.mibBrowser.refreshTree();
    }

    private void createActions() {
        this.actionWalk = new /* Unavailable Anonymous Inner Class!! */;
        this.actionWalk.setEnabled(this.getObject() != null);
        this.actionCopyObjectName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopySymbolicName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyType = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyRawValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSelect = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSelect.setEnabled(false);
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionCreateSnmpDci = new CreateSnmpDci((ObjectView)this);
        this.actionShortTextualNames = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowResultFilter = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowResultFilter.setImageDescriptor(SharedIcons.FILTER);
        this.addKeyBinding("M1+F2", (IAction)this.actionShowResultFilter);
    }

    private void selectInTree() {
        MibObject o;
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length == 1 && (o = MibCache.findObject((String)selection[0].getText(0), (boolean)false)) != null) {
            this.mibBrowser.setSelection(o);
        }
    }

    private void copyColumnToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowResultFilter);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowResultFilter);
        manager.add((IAction)this.actionShortTextualNames);
    }

    private void createTreeContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillTreeContextMenu(m));
        Menu menu = menuMgr.createContextMenu((Control)this.mibBrowser.getTreeControl());
        this.mibBrowser.getTreeControl().setMenu(menu);
    }

    protected void fillTreeContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionWalk);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyObjectName);
        manager.add((IContributionItem)new Separator());
    }

    private void createResultsPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillResultsContextMenu(m));
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillResultsContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowResultFilter);
        manager.add((IAction)this.actionShortTextualNames);
        manager.add((IContributionItem)new Separator());
        if (this.viewer.getSelection().isEmpty()) {
            return;
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopySymbolicName);
        manager.add((IAction)this.actionCopyType);
        manager.add((IAction)this.actionCopyValue);
        manager.add((IAction)this.actionCopyRawValue);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCreateSnmpDci);
    }

    private void setupViewerColumns() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("OID"));
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText("OID as text");
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Type"));
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Value"));
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Raw value"));
        tc.setWidth(300);
    }

    public void doWalk(String oid) {
        if (this.walkActive || this.getObject() == null) {
            return;
        }
        if (oid == null) {
            MibObject mibObject = this.mibBrowser.getSelection();
            if (mibObject == null) {
                return;
            }
            oid = mibObject.getObjectId().toString();
        }
        this.walkActive = true;
        this.actionWalk.setEnabled(false);
        this.walkData.clear();
        this.viewer.refresh();
        long nodeId = this.getObjectId();
        String queryOid = oid;
        this.walkObjectId = nodeId;
        16 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void onSnmpWalkData(long nodeId, List<SnmpValue> data) {
        this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getFullName() {
        return this.toolView ? this.getName() : super.getFullName();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("selection", this.mibBrowser.getSelection().getObjectId().toString());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.restoredSelection = memento.getAsString("selection", null);
    }

    static /* synthetic */ NXCSession access$000(MibExplorer x0) {
        return x0.session;
    }
}

