/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class CreateUserOrGroupDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(CreateUserOrGroupDialog.class);
    private LabeledText textLogin;
    private Button checkEdit;
    private String loginName;
    private boolean editAfterCreate;
    private boolean isUser;

    public CreateUserOrGroupDialog(Shell parentShell, boolean isUser) {
        super(parentShell);
        this.isUser = isUser;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isUser ? this.i18n.tr("Create New User") : this.i18n.tr("Create New Group"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textLogin = new LabeledText(dialogArea, 0);
        this.textLogin.setLabel(this.i18n.tr("Login name"));
        this.textLogin.getTextControl().setTextLimit(63);
        this.textLogin.getShell().setMinimumSize(300, 0);
        this.textLogin.setFocus();
        Label label = new Label(dialogArea, 0);
        label.setText("");
        this.checkEdit = new Button(dialogArea, 32);
        this.checkEdit.setText(this.i18n.tr("Define additional properties"));
        this.checkEdit.setSelection(true);
        return dialogArea;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public boolean isEditAfterCreate() {
        return this.editAfterCreate;
    }

    protected void okPressed() {
        this.loginName = this.textLogin.getText();
        this.editAfterCreate = this.checkEdit.getSelection();
        super.okPressed();
    }
}

