/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.worldmap.dialogs.GeoAreaSelectionDialog;

public class GeoAreaSelectionDialog
extends Dialog {
    private static final String TABLE_CONFIG_PREFIX = "GeoAreaSelectionDialog";
    private List<GeoArea> cachedAreaList;
    private TableViewer viewer;
    private int areaId = 0;

    public GeoAreaSelectionDialog(Shell parentShell, List<GeoArea> cachedAreaList) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.cachedAreaList = cachedAreaList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Geo Area");
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("GeoAreaSelectionDialog.cx", 300), settings.getAsInteger("GeoAreaSelectionDialog.cy", 400));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.cachedAreaList != null) {
            this.viewer.setInput((Object)this.cachedAreaList);
        } else {
            NXCSession session = Registry.getSession();
            4 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        }
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        this.areaId = selection.isEmpty() ? 0 : ((GeoArea)selection.getFirstElement()).getId();
        super.okPressed();
    }

    public int getAreaId() {
        return this.areaId;
    }
}

