/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.resources;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.resources.ThemeElement;
import org.netxms.nxmc.tools.RGBTransform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.transform.Transform;

@Root(name="theme")
public class Theme {
    @Attribute
    protected String name;
    @ElementMap
    protected Map<String, ThemeElement> elements = new HashMap();

    public static Theme load(File file) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (Theme)serializer.read(Theme.class, file, false);
    }

    public Theme() {
        this.name = "Unnamed";
    }

    public Theme(String name) {
        this.name = name;
    }

    public Theme(String name, Theme src) {
        this.name = name;
        this.elements.putAll(src.elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        try (FileWriter writer = new FileWriter(file);){
            serializer.write((Object)this, (Writer)writer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThemeElement getElement(String tag) {
        return (ThemeElement)this.elements.get(tag);
    }

    public void setElement(String tag, ThemeElement element) {
        this.elements.put(tag, element);
    }

    public List<String> getTags() {
        return new ArrayList<String>(this.elements.keySet());
    }

    public void setMissingElements(Theme src) {
        for (String tag : src.elements.keySet()) {
            this.elements.putIfAbsent(tag, (ThemeElement)src.elements.get(tag));
        }
    }

    static {
        XMLTools.registerTransform(RGB.class, (Transform)new RGBTransform());
    }
}

