/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import fr.brouillard.oss.commonmark.ext.notifications.NotificationsExtension;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.footnotes.FootnotesExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.image.attributes.ImageAttributesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownViewer
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownViewer.class);
    private static final List<Extension> extensions = List.of(AutolinkExtension.create(), FootnotesExtension.builder().inlineFootnotes(true).build(), ImageAttributesExtension.create(), InsExtension.create(), NotificationsExtension.create().withClassMapper(n -> "notification notification-" + n.name().toLowerCase()), TaskListItemsExtension.create(), StrikethroughExtension.create(), TablesExtension.create());
    private Browser browser;
    private Text textWidget;
    private String text = "";
    private int htmlDocumentHeight = 0;
    private Runnable renderCompletionHandler = null;
    private String htmlHeader;

    public MarkdownViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.browser = WidgetHelper.createBrowser((Composite)this, (int)0, null);
        if (this.browser != null) {
            this.browser.addProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
            this.browser.addLocationListener((LocationListener)new /* Unavailable Anonymous Inner Class!! */);
            FontData f = JFaceResources.getDefaultFont().getFontData()[0];
            this.htmlHeader = "<html><head><style>body { font-family: " + f.getName() + "; font-size: " + f.getHeight() + "px; font-weight: normal; margin: 0; padding: 0; }.notification { padding: 9.5px; margin-top: 0.5rem; margin-bottom: 1rem; border: 1px solid transparent; border-radius: 4px; font-size: 120%; font-weight: 500; } .notification p { padding: 0; margin: 0; } .notification-info { color: #07525e; background-color: #d1ecf1; border-color: #bee5eb; } .notification-success { color: #125522; background-color: #d4edda; border-color: #c3e6cb; } .notification-warning { color: #6a4d00; background-color: #fff3cd; border-color: #ffeeba; } .notification-error { color: #900000; background: #ffd2d2; border-color: #f1a899; } img { max-width: 100%; }p code { padding: 2px 4px; font-size: 90%; border-radius: 4px; color: #333; background-color: #f5f5f5; }pre code { display: block; padding: 9.5px; color: #333; word-break: break-all; word-wrap: break-word; background-color: #f5f5f5; border: 1px solid #ccc; border-radius: 4px; white-space: pre-wrap; }</style></head><body><div class=\"content\" style=\"padding-left: 5px; padding-right: 5px;\">";
        } else {
            this.textWidget = new Text((Composite)this, 778);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint != -1 || this.browser == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        return new Point(wHint == -1 ? 100 : wHint, this.htmlDocumentHeight);
    }

    public void setText(String text) {
        if (this.text.equals(text != null ? text : "")) {
            return;
        }
        String string = this.text = text != null ? text : "";
        if (this.browser != null) {
            String html;
            this.htmlDocumentHeight = 0;
            try {
                Parser parser = Parser.builder().extensions((Iterable)extensions).build();
                Node document = parser.parse(this.text);
                HtmlRenderer renderer = HtmlRenderer.builder().extensions((Iterable)extensions).build();
                html = this.htmlHeader + renderer.render(document) + "</div></body></html>";
            }
            catch (Exception e) {
                logger.error("Exception in Markdown renderer", (Throwable)e);
                html = this.htmlHeader + "<div class=\"notification notification-error\">Markdown rendering error</div><div>Original document source:</div><code>" + this.text.replace("\n", "<br/>") + "</code></div></body></html>";
            }
            this.browser.setText(html);
        } else {
            this.textWidget.setText(this.text);
        }
    }

    public String getText() {
        return this.text;
    }

    public Runnable getRenderCompletionHandler() {
        return this.renderCompletionHandler;
    }

    public void setRenderCompletionHandler(Runnable renderCompletionHandler) {
        this.renderCompletionHandler = renderCompletionHandler;
    }
}

