/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.AssetGroup;
import org.netxms.client.objects.AssetRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetListComparator;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetListFilter;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetListLabelProvider;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyReader;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class AssetSummaryView
extends ObjectView {
    static final I18n i18n = LocalizationHelper.getI18n(AssetSummaryView.class);
    private SortableTableViewer viewer;
    private AssetPropertyReader propertyReader;
    private Action actionHideEmptyColumns;
    private Action actionExportToCSV;
    private Action actionExportAllToCSV;

    public AssetSummaryView() {
        super(LocalizationHelper.getI18n(AssetSummaryView.class).tr("Assets"), ResourceManager.getImageDescriptor((String)"icons/object-views/asset.png"), "objects.assets", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof Container || context instanceof Collector || context instanceof Subnet || context instanceof Zone || context instanceof Rack || context instanceof Cluster || context instanceof AssetGroup || context instanceof AssetRoot);
    }

    public int getPriority() {
        return 70;
    }

    protected void createContent(Composite parent) {
        this.propertyReader = new AssetPropertyReader();
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.addColumn(i18n.tr("Asset"), -1);
        ArrayList attributes = new ArrayList(this.session.getAssetManagementSchema().values());
        attributes.sort((a1, a2) -> a1.getEffectiveDisplayName().compareToIgnoreCase(a2.getEffectiveDisplayName()));
        for (AssetAttribute a : attributes) {
            if (a.isHidden()) continue;
            TableColumn tc = this.viewer.addColumn(a.getEffectiveDisplayName(), -1);
            tc.setData("Attribute", (Object)a.getName());
        }
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AssetListLabelProvider(this.viewer, this.propertyReader));
        this.viewer.setComparator((ViewerComparator)new AssetListComparator(this.propertyReader));
        AssetListFilter filter = new AssetListFilter(this.propertyReader);
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createContextMenu();
    }

    void createActions() {
        this.actionExportAllToCSV = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionExportToCSV = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionHideEmptyColumns = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideEmptyColumns.setChecked(PreferenceStore.getInstance().getAsBoolean("AssetSummaryView.hideEmptyColumns", true));
        this.addKeyBinding("M1+H", (IAction)this.actionHideEmptyColumns);
    }

    protected void postContentCreate() {
        this.refresh();
    }

    public void refresh() {
        AbstractObject root = this.getObject();
        if (root == null) {
            this.viewer.setInput((Object)new Object[0]);
            return;
        }
        List assets = root.getAllChildren(-1).stream().filter(object -> object instanceof Asset || object.getAssetId() != 0L).collect(Collectors.toList());
        this.viewer.setInput(assets);
        boolean hideEmptyColumns = PreferenceStore.getInstance().getAsBoolean("AssetSummaryView.hideEmptyColumns", true);
        this.actionHideEmptyColumns.setChecked(hideEmptyColumns);
        if (!assets.isEmpty() && hideEmptyColumns) {
            this.hideEmptyColumns();
        } else {
            this.showAllColumns();
        }
        this.viewer.packColumns();
    }

    private void hideEmptyColumns() {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        for (int i = 1; i < columns.length; ++i) {
            boolean empty = true;
            String attr = (String)columns[i].getData("Attribute");
            for (Object o : (List)this.viewer.getInput()) {
                String v;
                Asset asset = this.getAsset(o);
                if (asset == null || (v = (String)asset.getProperties().get(attr)) == null || v.isEmpty()) continue;
                empty = false;
                break;
            }
            columns[i].setWidth(empty ? 0 : 100);
            columns[i].setResizable(!empty);
        }
    }

    private void showAllColumns() {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        for (int i = 1; i < columns.length; ++i) {
            columns[i].setResizable(true);
        }
    }

    private Asset getAsset(Object element) {
        if (element instanceof Asset) {
            return (Asset)element;
        }
        return (Asset)this.session.findObjectById(((AbstractObject)element).getAssetId(), Asset.class);
    }

    protected void onObjectUpdate(AbstractObject object) {
        super.onObjectUpdate(object);
        this.refresh();
    }

    public void dispose() {
        this.propertyReader.dispose();
        super.dispose();
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCSV);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionHideEmptyColumns);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCSV);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionExportToCSV);
        mgr.add((IAction)this.actionExportAllToCSV);
    }

    protected boolean isRelatedObject(long objectId) {
        AbstractObject object = this.getObject();
        return object != null && object.isParentOf(objectId);
    }

    protected void onObjectChange(AbstractObject object) {
        this.refresh();
    }
}

