/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.DataSeries;
import org.netxms.nxmc.modules.charts.api.GaugeColorMode;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.DialGauge;
import org.netxms.nxmc.modules.charts.widgets.GenericGauge;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;

public class DialGauge
extends GenericGauge {
    private static final int NEEDLE_PIN_RADIUS = 8;
    private static final int SCALE_OFFSET = 18;
    private static final int SCALE_WIDTH = 3;
    private static final int COLOR_RING_OFFSET = 2;
    private static final int COLOR_RING_WIDTH = 5;
    private static final int LABEL_TOP_MARGIN = 6;
    private Font[] scaleFonts = null;
    private Font[] valueFonts = null;

    public DialGauge(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
        int i;
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        for (i = 0; i < this.scaleFonts.length; ++i) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
        }
        this.valueFonts = new Font[16];
        for (i = 0; i < this.valueFonts.length; ++i) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 1);
        }
    }

    protected void disposeFonts() {
        int i;
        if (this.scaleFonts != null) {
            for (i = 0; i < this.scaleFonts.length; ++i) {
                this.scaleFonts[i].dispose();
            }
        }
        if (this.valueFonts != null) {
            for (i = 0; i < this.valueFonts.length; ++i) {
                this.valueFonts[i].dispose();
            }
        }
    }

    protected void renderElement(GC gc, ChartConfiguration configuration, Object renderData, ChartDciConfig dci, DataSeries data, int x, int y, int w, int h, int index) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        int heightAdjustment = rect.height / 6;
        rect.height += heightAdjustment;
        if (configuration.areLabelsVisible() && !configuration.areLabelsInside()) {
            rect.height -= gc.textExtent((String)"MMM").y + 6;
        }
        if (rect.height > rect.width) {
            rect.y += (rect.height - rect.width) / 2;
            rect.height = rect.width;
        } else {
            rect.x += (rect.width - rect.height) / 2;
            rect.width = rect.height;
        }
        double maxValue = configuration.getMaxYScaleValue();
        double minValue = configuration.getMinYScaleValue();
        double angleValue = (maxValue - minValue) / 270.0;
        int outerRadius = (rect.width + 1) / 2;
        int scaleOuterOffset = rect.width / 2 * 18 / 100;
        int scaleCenterOffset = rect.width / 2 * 21 / 100;
        int scaleInnerOffset = rect.width / 2 * 28 / 100;
        int cx = rect.x + rect.width / 2 + 1;
        int cy = rect.y + rect.height / 2 + 1;
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.PlotArea"));
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        GaugeColorMode colorMode = GaugeColorMode.getByValue((int)configuration.getGaugeColorMode());
        switch (1.$SwitchMap$org$netxms$nxmc$modules$charts$api$GaugeColorMode[colorMode.ordinal()]) {
            case 1: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, this.chart.getPaletteEntry(0).getRGBObject());
                break;
            }
            case 2: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, this.getDataSourceColor(dci, index));
                break;
            }
            case 3: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()).getRGB());
                break;
            }
            case 4: {
                double startAngle = 225.0;
                startAngle = this.drawZone(gc, rect, startAngle, minValue, configuration.getLeftRedZone(), angleValue, RED_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftRedZone(), configuration.getLeftYellowZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftYellowZone(), configuration.getRightYellowZone(), angleValue, GREEN_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightYellowZone(), configuration.getRightRedZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightRedZone(), maxValue, angleValue, RED_ZONE_COLOR);
                break;
            }
        }
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.PlotArea"));
        gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.PlotArea"));
        gc.fillArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, 0, 360);
        Color scaleColor = ThemeEngine.getForegroundColor((String)"Chart.DialScale");
        gc.setForeground(scaleColor);
        int textOffset = rect.width / 2 * 18 / 200;
        double arcLength = (double)(outerRadius - scaleOuterOffset) * 4.71238898038469;
        int step = arcLength >= 200.0 ? 27 : 54;
        double valueStep = Math.abs((maxValue - minValue) / (double)(arcLength >= 200.0 ? 10 : 20));
        int textWidth = (int)(Math.sqrt((outerRadius - scaleOuterOffset) * (outerRadius - scaleOuterOffset) / 2) * 0.7);
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)textWidth, (int)(outerRadius - scaleOuterOffset));
        gc.setFont(markFont);
        gc.setLineWidth(1);
        for (int i = 225; i >= -45; i -= step) {
            if (configuration.isGridVisible()) {
                gc.setForeground(scaleColor);
                Point l1 = this.positionOnArc(cx, cy, outerRadius - scaleOuterOffset, i);
                Point l2 = this.positionOnArc(cx, cy, outerRadius - scaleCenterOffset, i);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
            }
            double angle = (double)(225 - i) * angleValue + minValue;
            String value = DataFormatter.roundDecimalValue((double)angle, (double)valueStep, (int)5);
            Point t = this.positionOnArc(cx, cy, outerRadius - textOffset, i);
            Point ext = gc.textExtent(value);
            gc.drawText(value, t.x - ext.x / 2, t.y - ext.y / 2, 1);
        }
        gc.drawArc(rect.x + scaleCenterOffset, rect.y + scaleCenterOffset, rect.width - scaleCenterOffset * 2, rect.height - scaleCenterOffset * 2, -45, 270);
        double dciValue = data.getCurrentValue();
        if (dciValue < minValue) {
            dciValue = minValue;
        }
        if (dciValue > maxValue) {
            dciValue = maxValue;
        }
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)(Integer.toString((int)maxValue) + ".00"), (int)(outerRadius - scaleInnerOffset - 6), (int)(rect.height / 8)));
        switch (1.$SwitchMap$org$netxms$nxmc$modules$charts$api$GaugeColorMode[colorMode.ordinal()]) {
            case 1: {
                gc.setForeground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                break;
            }
            case 2: {
                gc.setForeground(this.chart.getColorCache().create(this.getDataSourceColor(dci, index)));
                break;
            }
            case 3: {
                gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                break;
            }
            case 4: {
                if (dciValue <= configuration.getLeftRedZone() || dciValue >= configuration.getRightRedZone()) {
                    gc.setForeground(this.chart.getColorCache().create(RED_ZONE_COLOR));
                    break;
                }
                if (dciValue <= configuration.getLeftYellowZone() || dciValue >= configuration.getRightYellowZone()) {
                    gc.setForeground(this.chart.getColorCache().create(YELLOW_ZONE_COLOR));
                    break;
                }
                gc.setForeground(this.chart.getColorCache().create(GREEN_ZONE_COLOR));
                break;
            }
            default: {
                gc.setForeground(scaleColor);
            }
        }
        String value = this.getValueAsDisplayString(dci, data);
        Point ext = gc.textExtent(value);
        gc.drawText(value, cx - ext.x / 2, cy + rect.height / 4 + 3, true);
        gc.setBackground(gc.getForeground());
        int angle = (int)(225.0 - (dciValue - minValue) / angleValue);
        Point needleEnd = this.positionOnArc(cx, cy, outerRadius - scaleInnerOffset, angle);
        Point np1 = this.positionOnArc(cx, cy, 4, angle - 90);
        Point np2 = this.positionOnArc(cx, cy, 4, angle + 90);
        gc.fillPolygon(new int[]{np1.x, np1.y, needleEnd.x, needleEnd.y, np2.x, np2.y});
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.DialNeedlePin"));
        gc.fillArc(cx - 8, cy - 8, 15, 15, 0, 360);
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.PlotArea"));
        gc.fillArc(cx - 4, cy - 4, 7, 7, 0, 360);
        if (configuration.areLabelsVisible()) {
            gc.setFont(configuration.areLabelsInside() ? WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"XXXXXXXXXXXXXXXXXXXXXXXX", (int)(rect.width - scaleInnerOffset * 2 - 6), (int)(rect.height / 8)) : null);
            ext = gc.textExtent(dci.getLabel());
            gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.Base"));
            if (configuration.areLabelsInside()) {
                gc.drawText(dci.getLabel(), rect.x + (rect.width - ext.x) / 2, rect.y + scaleCenterOffset / 2 + rect.height / 4, true);
            } else {
                gc.drawText(dci.getLabel(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 6 - heightAdjustment, true);
            }
        }
    }

    private double drawZone(GC gc, Rectangle rect, double startAngle, double minValue, double maxValue, double angleValue, RGB color) {
        if (minValue >= maxValue) {
            return startAngle;
        }
        double angle = (maxValue - minValue) / angleValue;
        if (angle <= 0.0) {
            return startAngle;
        }
        int offset = rect.width / 2 * 23 / 100;
        gc.setBackground(this.chart.getColorCache().create(color));
        gc.fillArc(rect.x + offset, rect.y + offset, rect.width - offset * 2, rect.height - offset * 2, (int)Math.ceil(startAngle), (int)(-Math.ceil(angle)));
        return startAngle - angle;
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }

    protected Point getMinElementSize() {
        return new Point(40, 40);
    }
}

