/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.xnap.commons.i18n.I18n;

public class Layout
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Layout.class);
    private Button checkGrabVerticalSpace;
    private LabeledSpinner spinnerHorizontalSpan;
    private LabeledSpinner spinnerVerticalSpan;
    private LabeledSpinner spinnerHeightHint;
    private Button checkShowOnNarrowScreen;
    private LabeledSpinner spinnerNSOrder;
    private LabeledSpinner spinnerNSHeightHint;
    private DashboardElementLayout elementLayout;

    public Layout(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(Layout.class).tr("Layout"), elementConfig);
    }

    public String getId() {
        return "layout";
    }

    protected Control createContents(Composite parent) {
        this.elementLayout = this.elementConfig.getLayout();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((org.eclipse.swt.widgets.Layout)layout);
        this.spinnerHorizontalSpan = new LabeledSpinner(dialogArea, 0);
        this.spinnerHorizontalSpan.setLabel(this.i18n.tr("Horizontal span"));
        this.spinnerHorizontalSpan.setRange(1, 128);
        this.spinnerHorizontalSpan.setSelection(this.elementLayout.horizontalSpan);
        this.spinnerHorizontalSpan.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerHeightHint = new LabeledSpinner(dialogArea, 0);
        this.spinnerHeightHint.setLabel(this.i18n.tr("Height hint (-1 to ignore)"));
        this.spinnerHeightHint.setRange(-1, 8192);
        this.spinnerHeightHint.setSelection(this.elementLayout.heightHint);
        this.spinnerHeightHint.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerVerticalSpan = new LabeledSpinner(dialogArea, 0);
        this.spinnerVerticalSpan.setLabel(this.i18n.tr("Vertical span"));
        this.spinnerVerticalSpan.setRange(1, 128);
        this.spinnerVerticalSpan.setSelection(this.elementLayout.verticalSpan);
        this.spinnerVerticalSpan.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.checkGrabVerticalSpace = new Button(dialogArea, 32);
        this.checkGrabVerticalSpace.setText(this.i18n.tr("Grab excessive vertical space"));
        this.checkGrabVerticalSpace.setSelection(this.elementLayout.grabVerticalSpace);
        this.checkGrabVerticalSpace.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label separator = new Label(dialogArea, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.checkShowOnNarrowScreen = new Button(dialogArea, 32);
        this.checkShowOnNarrowScreen.setText(this.i18n.tr("Visible in narrow screen mode"));
        this.checkShowOnNarrowScreen.setSelection(this.elementLayout.showInNarrowScreenMode);
        this.checkShowOnNarrowScreen.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.checkShowOnNarrowScreen.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.spinnerNSOrder = new LabeledSpinner(dialogArea, 0);
        this.spinnerNSOrder.setLabel(this.i18n.tr("Display order in narrow screen mode"));
        this.spinnerNSOrder.setRange(0, 255);
        this.spinnerNSOrder.setSelection(this.elementLayout.narrowScreenOrder);
        this.spinnerNSOrder.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerNSOrder.setEnabled(this.elementLayout.showInNarrowScreenMode);
        this.spinnerNSHeightHint = new LabeledSpinner(dialogArea, 0);
        this.spinnerNSHeightHint.setLabel(this.i18n.tr("Height hint for narrow screen mode (-1 to ignore)"));
        this.spinnerNSHeightHint.setRange(-1, 8192);
        this.spinnerNSHeightHint.setSelection(this.elementLayout.narrowScreenHeightHint);
        this.spinnerNSHeightHint.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerNSHeightHint.setEnabled(this.elementLayout.showInNarrowScreenMode);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.elementLayout.grabVerticalSpace = this.checkGrabVerticalSpace.getSelection();
        this.elementLayout.horizontalSpan = this.spinnerHorizontalSpan.getSelection();
        this.elementLayout.verticalSpan = this.spinnerVerticalSpan.getSelection();
        this.elementLayout.heightHint = this.spinnerHeightHint.getSelection();
        this.elementLayout.showInNarrowScreenMode = this.checkShowOnNarrowScreen.getSelection();
        this.elementLayout.narrowScreenOrder = this.spinnerNSOrder.getSelection();
        this.elementLayout.narrowScreenHeightHint = this.spinnerNSHeightHint.getSelection();
        return true;
    }
}

