/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class ScriptedChart
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ScriptedChart.class);
    private ScriptedComparisonChartConfig config;
    private ObjectSelector objectSelector;
    private ScriptEditor scriptEditor;

    public ScriptedChart(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(ScriptedChart.class).tr("Script"), elementConfig);
    }

    public String getId() {
        return "scripted-chart";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof ScriptedComparisonChartConfig;
    }

    public int getPriority() {
        return 20;
    }

    protected Control createContents(Composite parent) {
        this.config = (ScriptedComparisonChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        this.objectSelector.setEmptySelectionName(this.i18n.tr("<dashboard>"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        new Label(dialogArea, 0).setText(this.i18n.tr("Script"));
        this.scriptEditor = new ScriptEditor(dialogArea, 2048, 770);
        this.scriptEditor.setText(this.config.getScript());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.scriptEditor.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setScript(this.scriptEditor.getText());
        return true;
    }
}

