/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ServiceComponentsConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.networkmaps.widgets.NetworkMapWidget;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceComponentsElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(ServiceComponentsElement.class);
    private NetworkMapWidget mapWidget;
    private NetworkMapPage mapPage;
    private ServiceComponentsConfig config;
    private NXCSession session;

    protected ServiceComponentsElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = (ServiceComponentsConfig)new Gson().fromJson(element.getData(), ServiceComponentsConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new ServiceComponentsConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.session = Registry.getSession();
        long rootObjectId = this.getEffectiveObjectId(this.config.getObjectId());
        this.mapPage = new NetworkMapPage("ServiceComponents." + rootObjectId);
        long elementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, rootObjectId));
        this.addServiceComponents(this.session.findObjectById(rootObjectId), elementId);
        if (this.mapPage != null) {
            this.mapWidget = new NetworkMapWidget(this.getContentArea(), 0, (View)view);
            this.mapWidget.setLayoutAlgorithm(this.config.getDefaultLayoutAlgorithm());
            this.mapWidget.zoomTo((double)this.config.getZoomLevel() / 100.0);
            this.mapWidget.getLabelProvider().setObjectFigureType(this.config.getObjectDisplayMode());
            this.mapWidget.getLabelProvider().setShowStatusIcons((this.config.getFlags() & 1) != 0);
            this.mapWidget.getLabelProvider().setShowStatusFrame((this.config.getFlags() & 2) != 0);
            this.mapWidget.getLabelProvider().setShowStatusBackground((this.config.getFlags() & 4) != 0);
            this.mapWidget.getLabelProvider().setTranslucentLabelBackground((this.config.getFlags() & 0x200) != 0);
            this.mapWidget.setConnectionRouter(this.config.getDefaultLinkRouting());
            if (this.config.getDefaultLinkColor() >= 0) {
                this.mapWidget.getLabelProvider().setDefaultLinkColor(new Color((Device)this.mapWidget.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.config.getDefaultLinkColor())));
            }
            this.mapWidget.setContent(this.mapPage);
        }
        if (this.config.isObjectDoubleClickEnabled()) {
            this.mapWidget.enableObjectDoubleClick();
        }
    }

    private void addServiceComponents(AbstractObject object, long parentElementId) {
        if (object == null) {
            return;
        }
        Iterator it = object.getChildren();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            AbstractObject child = this.session.findObjectById(objectId);
            if (child == null || !(child instanceof Collector) && !(child instanceof Container) && !(child instanceof Cluster) && !(child instanceof Node) && !(child instanceof Condition)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, parentElementId, elementId));
            this.addServiceComponents(child, elementId);
        }
    }
}

