/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class OtherOptions
extends AbstractDCIPropertyPage {
    private static final String[] TAGS = new String[]{"iface-inbound-bits", "iface-inbound-bytes", "iface-inbound-util", "iface-outbound-bits", "iface-outbound-bytes", "iface-outbound-util", "iface-speed"};
    private final I18n i18n = LocalizationHelper.getI18n(OtherOptions.class);
    private DataCollectionItem dci;
    private Button checkShowOnTooltip;
    private Button checkShowInOverview;
    private Button checkCalculateStatus;
    private Button checkHideInViewMode;
    private Button checkUnsupportedAsError;
    private LabeledCombo multiplierDegree;
    private LabeledCombo agentCacheMode;
    private LabeledCombo interpretation;
    private LabeledText userTag;
    private ObjectSelector relatedObject;

    public OtherOptions(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(OtherOptions.class).tr("Other Options"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.checkShowOnTooltip = new Button(dialogArea, 32);
        this.checkShowOnTooltip.setText(this.i18n.tr("&Show last value in object tooltips and large labels on maps"));
        this.checkShowOnTooltip.setSelection(this.dci.isShowOnObjectTooltip());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkShowOnTooltip.setLayoutData((Object)gd);
        this.checkShowInOverview = new Button(dialogArea, 32);
        this.checkShowInOverview.setText(this.i18n.tr("Show last value in object &overview"));
        this.checkShowInOverview.setSelection(this.dci.isShowInObjectOverview());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkShowInOverview.setLayoutData((Object)gd);
        this.checkCalculateStatus = new Button(dialogArea, 32);
        this.checkCalculateStatus.setText(this.i18n.tr("&Use this DCI for node status calculation"));
        this.checkCalculateStatus.setSelection(this.dci.isUsedForNodeStatusCalculation());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkCalculateStatus.setLayoutData((Object)gd);
        this.checkHideInViewMode = new Button(dialogArea, 32);
        this.checkHideInViewMode.setText(this.i18n.tr("&Hide in view mode"));
        this.checkHideInViewMode.setSelection(this.dci.isHideOnLastValuesView());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkHideInViewMode.setLayoutData((Object)gd);
        this.checkUnsupportedAsError = new Button(dialogArea, 32);
        this.checkUnsupportedAsError.setText(this.i18n.tr("Interpret &unsupported state as data collection error"));
        this.checkUnsupportedAsError.setSelection(this.dci.isUnsupportedAsError());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkUnsupportedAsError.setLayoutData((Object)gd);
        this.agentCacheMode = new LabeledCombo(dialogArea, 0);
        this.agentCacheMode.setLabel(this.i18n.tr("Agent cache mode"));
        this.agentCacheMode.add(this.i18n.tr("Default"));
        this.agentCacheMode.add(this.i18n.tr("On"));
        this.agentCacheMode.add(this.i18n.tr("Off"));
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.agentCacheMode.setLayoutData((Object)gd);
        this.multiplierDegree = new LabeledCombo(dialogArea, 0);
        this.multiplierDegree.setLabel(this.i18n.tr("Multiplier degree"));
        this.multiplierDegree.add("Fixed to P");
        this.multiplierDegree.add("Fixed to T");
        this.multiplierDegree.add("Fixed to G");
        this.multiplierDegree.add("Fixed to M");
        this.multiplierDegree.add("Fixed to K");
        this.multiplierDegree.add("Default");
        this.multiplierDegree.add("Fixed to m");
        this.multiplierDegree.add("Fixed to \u03bc");
        this.multiplierDegree.add("Fixed to n");
        this.multiplierDegree.add("Fixed to p");
        this.multiplierDegree.add("Fixed to f");
        this.multiplierDegree.select(5 - this.dci.getMultiplier());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.multiplierDegree.setLayoutData((Object)gd);
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.relatedObject.setLayoutData((Object)gd);
        this.interpretation = new LabeledCombo(dialogArea, 0);
        this.interpretation.setLabel(this.i18n.tr("Interpretation"));
        this.interpretation.add(this.i18n.tr("Other"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Inbound - bits/sec"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Inbound - bytes/sec"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Inbound - Utilization %"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Outbound - bits/sec"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Outbound - bytes/sec"));
        this.interpretation.add(this.i18n.tr("Interface traffic - Outbound - Utilization %"));
        this.interpretation.add(this.i18n.tr("Interface speed"));
        this.interpretation.select(OtherOptions.interpretationFromTag((String)this.dci.getSystemTag()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.interpretation.setLayoutData((Object)gd);
        this.userTag = new LabeledText(dialogArea, 0);
        this.userTag.setLabel(this.i18n.tr("Tag"));
        this.userTag.setText(this.dci.getUserTag());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.userTag.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setShowOnObjectTooltip(this.checkShowOnTooltip.getSelection());
        this.dci.setShowInObjectOverview(this.checkShowInOverview.getSelection());
        this.dci.setUsedForNodeStatusCalculation(this.checkCalculateStatus.getSelection());
        this.dci.setHideOnLastValuesView(this.checkHideInViewMode.getSelection());
        this.dci.setUnsupportedAsError(this.checkUnsupportedAsError.getSelection());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setMultiplier(5 - this.multiplierDegree.getSelectionIndex());
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.dci.setSystemTag(OtherOptions.tagFromInterpretation((int)this.interpretation.getSelectionIndex()));
        this.dci.setUserTag(this.userTag.getText().trim());
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkShowOnTooltip.setSelection(false);
        this.checkShowInOverview.setSelection(false);
        this.checkCalculateStatus.setSelection(false);
        this.checkHideInViewMode.setSelection(false);
        this.checkUnsupportedAsError.setSelection(false);
        this.agentCacheMode.select(0);
        this.multiplierDegree.select(0);
        this.relatedObject.setObjectId(0L);
        this.interpretation.select(0);
        this.userTag.setText("");
    }

    private static int interpretationFromTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < TAGS.length; ++i) {
            if (!tag.equalsIgnoreCase(TAGS[i])) continue;
            return i + 1;
        }
        return 0;
    }

    private static String tagFromInterpretation(int index) {
        return index > 0 && index <= TAGS.length ? TAGS[index - 1] : "";
    }
}

