/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.TableColumnEnumerator;
import org.netxms.nxmc.modules.datacollection.dialogs.EditTableThresholdDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.TableThresholdLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableThresholds
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(TableThresholds.class);
    private static final String COLUMN_SETTINGS_PREFIX = "TableThresholds.ColumnList";
    private DataCollectionTable dci;
    private List<TableThreshold> thresholds;
    private TableViewer thresholdList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Button duplicateButton;

    public TableThresholds(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(TableThresholds.class).tr("Table Thresholds"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        if (this.editor.getTableColumnEnumerator() == null) {
            ArrayList columns = new ArrayList();
            for (ColumnDefinition c : this.dci.getColumns()) {
                columns.add(new ColumnDefinition(c));
            }
            this.editor.setTableColumnEnumerator((TableColumnEnumerator)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.thresholds = new ArrayList();
        for (TableThreshold t : this.dci.getThresholds()) {
            this.thresholds.add(new TableThreshold(t));
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite thresholdListArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        thresholdListArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        thresholdListArea.setLayout((Layout)layout);
        new Label(thresholdListArea, 0).setText(this.i18n.tr("Thresholds"));
        this.thresholdList = new TableViewer(thresholdListArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.thresholdList.getControl().setLayoutData((Object)gd);
        this.setupThresholdList();
        this.thresholdList.setInput((Object)this.thresholds.toArray());
        Composite leftButtons = new Composite(thresholdListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("Dow&n"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(thresholdListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.duplicateButton = new Button(buttons, 8);
        this.duplicateButton.setText("Duplicate");
        rd = new RowData();
        rd.width = 90;
        this.duplicateButton.setLayoutData((Object)rd);
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(this.i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.thresholdList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.thresholdList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void setupThresholdList() {
        Table table = this.thresholdList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Condition"));
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText("Samples");
        column.setWidth(90);
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Activation Event"));
        column.setWidth(140);
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Deactivation Event"));
        column.setWidth(140);
        WidgetHelper.restoreColumnSettings((Table)table, (String)COLUMN_SETTINGS_PREFIX);
        this.thresholdList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.thresholdList.setLabelProvider((IBaseLabelProvider)new TableThresholdLabelProvider());
    }

    private void deleteThresholds() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.thresholds.remove(it.next());
            }
            this.thresholdList.setInput((Object)this.thresholds.toArray());
        }
    }

    private void editThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1) {
            TableThreshold t = (TableThreshold)selection.getFirstElement();
            EditTableThresholdDialog dlg = new EditTableThresholdDialog(this.getShell(), t, this.editor.getTableColumnEnumerator());
            if (dlg.open() == 0) {
                this.thresholdList.update((Object)t, null);
            }
        }
    }

    private void addThreshold() {
        TableThreshold t = new TableThreshold();
        EditTableThresholdDialog dlg = new EditTableThresholdDialog(this.getShell(), t, this.editor.getTableColumnEnumerator());
        if (dlg.open() == 0) {
            this.thresholds.add(t);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    private void duplicateThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() > 0) {
            List list = selection.toList();
            for (TableThreshold t : list) {
                this.thresholds.add(this.thresholds.indexOf(t) + 1, t.duplicate());
                this.thresholdList.setInput((Object)this.thresholds.toArray());
            }
        }
    }

    private void moveSelectionUp() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TableThreshold t = (TableThreshold)selection.getFirstElement();
        int index = this.thresholds.indexOf(t);
        if (index > 0) {
            Collections.swap(this.thresholds, index, index - 1);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    private void moveSelectionDown() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TableThreshold t = (TableThreshold)selection.getFirstElement();
        int index = this.thresholds.indexOf(t);
        if (index < this.thresholds.size() - 1) {
            Collections.swap(this.thresholds, index, index + 1);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.saveSettings();
        this.dci.getThresholds().clear();
        this.dci.getThresholds().addAll(this.thresholds);
        this.editor.modify();
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        if (this.thresholdList != null) {
            WidgetHelper.saveColumnSettings((Table)this.thresholdList.getTable(), (String)COLUMN_SETTINGS_PREFIX);
        }
    }
}

