/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.ThresholdViolationSummary;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.ThresholdLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ThresholdTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();
    private ThresholdLabelProvider thresholdLabelProvider = new ThresholdLabelProvider();
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ThresholdViolationSummary && columnIndex == 0) {
            AbstractObject node = this.session.findObjectById(((ThresholdViolationSummary)element).getNodeId());
            return node != null ? this.objectLabelProvider.getImage((Object)node) : null;
        }
        if (element instanceof ThresholdViolationSummary && columnIndex == 1) {
            return StatusDisplayInfo.getStatusImage((Severity)((ThresholdViolationSummary)element).getCurrentSeverity());
        }
        if (element instanceof DciValue && columnIndex == 1) {
            return StatusDisplayInfo.getStatusImage((Severity)((DciValue)element).getActiveThreshold().getCurrentSeverity());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ThresholdViolationSummary) {
            switch (columnIndex) {
                case 0: {
                    return this.session.getObjectNameWithAlias(((ThresholdViolationSummary)element).getNodeId());
                }
                case 1: {
                    return StatusDisplayInfo.getStatusText((Severity)((ThresholdViolationSummary)element).getCurrentSeverity());
                }
            }
            return null;
        }
        if (element instanceof DciValue) {
            switch (columnIndex) {
                case 1: {
                    return StatusDisplayInfo.getStatusText((Severity)((DciValue)element).getActiveThreshold().getCurrentSeverity());
                }
                case 2: {
                    return ((DciValue)element).getDescription();
                }
                case 3: {
                    return ((DciValue)element).getValue();
                }
                case 4: {
                    return this.thresholdLabelProvider.getColumnText((Object)((DciValue)element).getActiveThreshold(), 0);
                }
                case 5: {
                    return this.thresholdLabelProvider.getColumnText((Object)((DciValue)element).getActiveThreshold(), 1);
                }
                case 6: {
                    return DateFormatFactory.getDateTimeFormat().format(((DciValue)element).getActiveThreshold().getLastEventTimestamp());
                }
            }
            return null;
        }
        return null;
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        this.thresholdLabelProvider.dispose();
        super.dispose();
    }
}

