/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventSelectionDialog;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.propertypages.RuleEvents;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class RuleEvents
extends RuleBasePropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RuleEvents.class);
    private final String[] EMPTY_LIST_PLACEHOLDER = new String[]{this.i18n.tr("Any event")};
    private NXCSession session;
    private SortableTableViewer viewer;
    private Map<Integer, EventTemplate> events = new HashMap();
    private Button addButton;
    private Button deleteButton;
    private Button checkInverted;

    public RuleEvents(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleEvents.class).tr("Events"));
        this.session = Registry.getSession();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        this.checkInverted.setText(this.i18n.tr("Inverse rule (match events NOT listed below)"));
        this.checkInverted.setSelection(this.rule.isEventsInverted());
        String[] columnNames = new String[]{this.i18n.tr("Events")};
        int[] columnWidths = new int[]{300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        for (EventTemplate o : this.session.findMultipleEventTemplates((Collection)this.rule.getEvents())) {
            this.events.put(o.getCode(), o);
        }
        this.setViewerInput();
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        return dialogArea;
    }

    private void addEvent() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            for (EventTemplate e : dlg.getSelectedEvents()) {
                this.events.put(e.getCode(), e);
            }
        }
        this.setViewerInput();
    }

    private void deleteEvent() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                EventTemplate e = (EventTemplate)it.next();
                this.events.remove(e.getCode());
            }
            this.setViewerInput();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = this.rule.getFlags();
        flags = this.checkInverted.getSelection() && !this.events.isEmpty() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        this.rule.setFlags(flags);
        this.rule.setEvents(new ArrayList(this.events.keySet()));
        this.editor.setModified(true);
        return true;
    }

    private void setViewerInput() {
        if (this.events.isEmpty()) {
            this.viewer.setInput((Object)this.EMPTY_LIST_PLACEHOLDER);
        } else {
            this.viewer.setInput((Object)this.events.values().toArray());
        }
    }
}

